/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;

public class CompostTowerRenderer
extends SafeBlockEntityRenderer<CompostTowerBlockEntity> {
    public CompostTowerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CompostTowerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        this.renderFluids(be, partialTicks, ms, bufferSource, light);
        this.renderItems(be, partialTicks, ms, bufferSource, light, overlay);
    }

    private void renderFluids(CompostTowerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light) {
        float capHeight = 0.2f;
        float tankHullWidth = 0.0078125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        Fluid[] sortedFluids = be.tankInventory.getSortedFluids();
        float accumulatedFluidHeight = 0.0f;
        float accumulatedGasHeight = 0.0f;
        for (Fluid fluid : sortedFluids) {
            float yEnd;
            float yStart;
            float ratio;
            boolean isGas = fluid.getFluidType().isLighterThanAir();
            LerpedFloat levelValue = (isGas ? be.gasLevels : be.fluidLevels).get(fluid);
            if (levelValue == null || (ratio = levelValue.getValue(partialTicks)) < 1.0f / (512.0f * totalHeight)) continue;
            float fluidHeight = ratio * totalHeight;
            if (isGas) {
                yStart = totalHeight - accumulatedGasHeight - fluidHeight + capHeight + minPuddleHeight;
                yEnd = totalHeight - accumulatedGasHeight + capHeight + minPuddleHeight;
                accumulatedGasHeight += fluidHeight;
            } else {
                yStart = accumulatedFluidHeight + capHeight + minPuddleHeight;
                yEnd = accumulatedFluidHeight + fluidHeight + capHeight + minPuddleHeight;
                accumulatedFluidHeight += fluidHeight;
            }
            float xMin = tankHullWidth;
            float xMax = xMin + (float)be.radius - 2.0f * tankHullWidth;
            float zMin = tankHullWidth;
            float zMax = zMin + (float)be.radius - 2.0f * tankHullWidth;
            ms.pushPose();
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox(fluid.defaultFluidState(), xMin, yStart, zMin, xMax, yEnd, zMax, bufferSource, ms, light, false, true);
            ms.popPose();
        }
    }

    private void renderItems(CompostTowerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float fluidSurfaceY = this.getFluidSurfaceLocalY(be, partialTicks);
        if (fluidSurfaceY >= (float)be.getHeight() - 0.1875f) {
            return;
        }
        this.renderInventoryItems(be, be.inputInventory, fluidSurfaceY, partialTicks, ms, buffer, light, overlay, 0.0f);
        this.renderInventoryItems(be, be.outputInventory, fluidSurfaceY, partialTicks, ms, buffer, light, overlay, 90.0f);
    }

    private void renderInventoryItems(CompostTowerBlockEntity be, ItemStackHandler inventory, float fluidSurfaceY, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, float angleOffset) {
        int radius = be.getWidth();
        RandomSource random = RandomSource.create((long)be.getBlockPos().hashCode());
        int itemCount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).isEmpty()) continue;
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        boolean hasFluid = fluidSurfaceY > 0.01f;
        float baseY = hasFluid ? fluidSurfaceY - 0.125f : 0.0625f;
        float angleStep = 360.0f / (float)itemCount;
        int index = 0;
        ms.pushPose();
        ms.translate((float)radius / 2.0f, 0.0f, (float)radius / 2.0f);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            ms.pushPose();
            float angle = angleStep * (float)index++ + angleOffset;
            if (hasFluid) {
                float bob = (Mth.sin((float)(AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) / 12.0f + angle)) + 1.5f) * 0.03125f;
                ms.translate(0.0f, bob, 0.0f);
            }
            Vec3 offset = VecHelper.rotate((Vec3)new Vec3((double)((float)radius * 0.2f), (double)baseY, 0.0), (double)angle, (Direction.Axis)Direction.Axis.Y);
            ms.translate(offset.x, offset.y, offset.z);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(angle + 35.0f)).rotateXDegrees(65.0f);
            int renderCount = Math.max(1, stack.getCount() / 8);
            for (int i = 0; i < renderCount; ++i) {
                ms.pushPose();
                Vec3 jitter = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)random, (float)0.0625f);
                ms.translate(jitter.x, jitter.y, jitter.z);
                this.renderItem(ms, buffer, light, overlay, stack);
                ms.popPose();
            }
            ms.popPose();
        }
        ms.popPose();
    }

    protected void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.level, 0);
    }

    private float getFluidSurfaceLocalY(CompostTowerBlockEntity be, float partialTicks) {
        float capHeight = 0.2f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float accumulatedFluidHeight = 0.0f;
        for (Fluid fluid : be.tankInventory.getSortedFluids()) {
            LerpedFloat lerp;
            if (fluid.getFluidType().isLighterThanAir() || (lerp = be.fluidLevels.get(fluid)) == null) continue;
            float ratio = lerp.getValue(partialTicks);
            accumulatedFluidHeight += ratio * totalHeight;
        }
        return accumulatedFluidHeight + capHeight + minPuddleHeight;
    }

    public boolean shouldRenderOffScreen(CompostTowerBlockEntity be) {
        return be.isController();
    }
}

