/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.compost_tower.CompostData;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlock;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class CompostTowerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    public ItemStackHandler inputInventory = new ItemStackHandler(3);
    public ItemStackHandler outputInventory = new ItemStackHandler(3);
    protected CompostTowerInventoryHandler itemCapability;
    protected CompostTowerFluidHandler fluidCapability;
    private boolean updateConnectivity = true;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected CompostData compostData;
    public CompostFluidTank tankInventory = new CompostFluidTank(FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    public HashMap<Fluid, LerpedFloat> fluidLevels = new HashMap();
    public HashMap<Fluid, LerpedFloat> gasLevels = new HashMap();
    protected int height = 1;
    protected int radius = 1;

    public CompostTowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.compostData = new CompostData();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.COMPOST_TOWER_BLOCK_ENTITY.get(), (be, context) -> {
            be.initCapability();
            if (be.fluidCapability == null) {
                return null;
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.COMPOST_TOWER_BLOCK_ENTITY.get(), (be, context) -> {
            be.initCapability();
            if (be.itemCapability == null) {
                return null;
            }
            return be.itemCapability;
        });
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)tester);
        if (this.level == null) {
            return false;
        }
        if (this.compostData.lastRecipe != null && this.compostData.lastRecipe.matches((RecipeInput)inventoryIn, this.level)) {
            return true;
        }
        return CRRecipeTypes.COMPOSTING.find(inventoryIn, this.level).isPresent();
    }

    private int getTowerHeight() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return 1;
        }
        return be.height;
    }

    private int getOutputHeight() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return 0;
        }
        return this.getBlockPos().getY() - be.getBlockPos().getY();
    }

    public int getTankSize(int tank) {
        return FluidTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(1);
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FluidTankBlockEntity.getCapacityMultiplier());
        this.tankInventory.clearOverflow();
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluidInTank(tank);
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.radius - 1), (double)(this.height - 1), (double)(this.radius - 1));
        }
        return super.createRenderBoundingBox();
    }

    public void initialize() {
        super.initialize();
        this.notifyUpdate();
        if (this.level != null && this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition)) {
            this.removeController(true);
            this.lastKnownPos = this.worldPosition;
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.isController()) {
            this.compostData.tick(this);
        }
        this.fluidLevels.values().forEach(LerpedFloat::tickChaser);
        this.gasLevels.values().forEach(LerpedFloat::tickChaser);
    }

    private void initCapability() {
        if (this.level == null) {
            return;
        }
        CompostTowerBlockEntity controller = this.getControllerBE();
        if (this.itemCapability != null && this.fluidCapability != null || controller == null) {
            return;
        }
        if (this.isController()) {
            this.itemCapability = new CompostTowerInventoryHandler();
            this.fluidCapability = new CompostTowerFluidHandler(this.tankInventory);
        } else {
            controller.initCapability();
            this.itemCapability = controller.itemCapability;
            this.fluidCapability = new CompostTowerFluidHandler(controller.tankInventory);
        }
    }

    private void refreshCapability() {
        this.itemCapability = null;
        this.fluidCapability = null;
        this.invalidateCapabilities();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    public CompostTowerBlockEntity getControllerBE() {
        if (this.level == null) {
            return null;
        }
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof CompostTowerBlockEntity) {
            CompostTowerBlockEntity CompostTowerBlockEntity2 = (CompostTowerBlockEntity)blockEntity;
            return CompostTowerBlockEntity2;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void setController(BlockPos pos) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (pos.equals((Object)this.controller)) {
            return;
        }
        this.controller = pos;
        this.refreshCapability();
        this.notifyUpdate();
    }

    public void removeController(boolean keepContents) {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.radius = 1;
        this.height = 1;
        this.refreshCapability();
        this.compostData.clear();
        this.tankInventory.onContentsChanged();
        this.notifyUpdate();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void updateConnectivity() {
        if (this.level == null) {
            return;
        }
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void notifyMultiUpdated() {
        if (this.level == null) {
            return;
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CompostTowerBlock.IS_2x2, (Comparable)Boolean.valueOf(this.getWidth() == 2)), 6);
        this.refreshCapability();
        this.tankInventory.onContentsChanged();
        this.updateCompostTowerState();
        if (this.isController()) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                    for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                        BlockPos vaultPos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                        CompostTowerBlockEntity partAt = (CompostTowerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntityTypes.COMPOST_TOWER_BLOCK_ENTITY.get()), (BlockGetter)this.level, (BlockPos)vaultPos);
                        if (partAt == null || this == partAt) continue;
                        this.tankInventory.fillFrom(partAt.tankInventory);
                        partAt.tankInventory.clear();
                    }
                }
            }
        }
        this.notifyUpdate();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 7;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    private boolean outputFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CompostTowerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        Lang.translate("gui.goggles.current_layer_fluid_output", new Object[0]).forGoggles(tooltip);
        int outputHeight = this.getOutputHeight();
        int towerHeight = this.getTowerHeight();
        Fluid availFluid = controllerBE.tankInventory.getFluidAtBlockHeight(outputHeight, towerHeight);
        FluidStack fluidStack = new FluidStack(availFluid, 1);
        Lang.fluidName(fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CompostTowerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null || this.level == null) {
            return false;
        }
        if (!this.outputFluidTooltip(tooltip, isPlayerSneaking)) {
            return false;
        }
        return controllerBE.compostData.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public void updateCompostTowerState() {
        if (!this.isController() && this.getControllerBE() != null) {
            this.getControllerBE().updateCompostTowerState();
            return;
        }
        if (this.compostData.evaluate(this)) {
            this.notifyUpdate();
        }
    }

    public void updateCompostData() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.compostData.updateRequired = 2;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevHeight = this.height;
        this.updateConnectivity = tag.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (tag.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"LastKnownPos");
        }
        if (tag.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)tag, (String)"Controller");
        }
        if (this.isController()) {
            this.radius = tag.getInt("Size");
            this.height = tag.getInt("Height");
            this.tankInventory.deserializeNBT(registries, tag.getCompound("TankContent"));
            this.inputInventory.deserializeNBT(registries, tag.getCompound("InputInv"));
            this.outputInventory.deserializeNBT(registries, tag.getCompound("OutputInv"));
            this.applyFluidTankSize(this.getTotalTankSize());
            for (Fluid fluid : this.tankInventory.getSortedFluids()) {
                HashMap<Fluid, LerpedFloat> targetLevel = fluid.getFluidType().isLighterThanAir() ? this.gasLevels : this.fluidLevels;
                LerpedFloat fluidLevel = targetLevel.get(fluid);
                if (fluidLevel == null) {
                    fluidLevel = LerpedFloat.linear().startWithValue((double)this.tankInventory.getFilledPercentage(fluid));
                    targetLevel.put(fluid, fluidLevel);
                }
                fluidLevel.chase((double)this.tankInventory.getFilledPercentage(fluid), 0.5, LerpedFloat.Chaser.EXP);
            }
        }
        this.compostData.read(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.level != null && (changeOfController || prevSize != this.radius || prevHeight != this.height)) {
            this.level.setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.applyFluidTankSize(this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public int getTotalTankSize() {
        return this.radius * this.radius * this.height;
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            tag.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            tag.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            tag.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            tag.putInt("Size", this.radius);
            tag.putInt("Height", this.height);
            this.applyFluidTankSize(this.getTotalTankSize());
            tag.put("TankContent", (Tag)this.tankInventory.serializeNBT(registries));
            tag.put("InputInv", (Tag)this.inputInventory.serializeNBT(registries));
            tag.put("OutputInv", (Tag)this.outputInventory.serializeNBT(registries));
        }
        super.write(tag, registries, clientPacket);
        this.compostData.write(tag, clientPacket);
    }

    protected void onFluidStackChanged(HashMap<Fluid, Integer> tanks) {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide) {
            this.notifyUpdate();
        }
    }

    public class CompostTowerInventoryHandler
    extends CombinedInvWrapper {
        public CompostTowerInventoryHandler() {
            super(new IItemHandlerModifiable[]{CompostTowerBlockEntity.this.inputInventory, CompostTowerBlockEntity.this.outputInventory});
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (CompostTowerBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return CompostTowerBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (CompostTowerBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CompostTowerBlockEntity.this.inputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }

    public class CompostTowerFluidHandler
    extends CompostFluidTank {
        public CompostTowerFluidHandler(CompostFluidTank tank) {
            super(tank.fluidIds, tank.tanks, tank.updateCallback, tank.index, tank.capacity);
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int outputHeight = CompostTowerBlockEntity.this.getOutputHeight();
            int towerHeight = CompostTowerBlockEntity.this.getTowerHeight();
            Fluid availFluid = this.getFluidAtBlockHeight(outputHeight, towerHeight);
            if (!resource.getFluid().isSame(availFluid)) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int outputHeight = CompostTowerBlockEntity.this.getOutputHeight();
            int towerHeight = CompostTowerBlockEntity.this.getTowerHeight();
            Fluid availFluid = this.getFluidAtBlockHeight(outputHeight, towerHeight);
            return super.drain(new FluidStack(availFluid, maxDrain), action);
        }
    }
}

