/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.recipe.trie.RecipeTrie;
import com.simibubi.create.foundation.recipe.trie.RecipeTrieFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;
import org.forsteri.ratatouille.content.compost_tower.CompostingRecipe;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class CompostData {
    public int sizeLevel;
    public int tempLevel;
    public int updateRequired;
    public int timer;
    public CompostingRecipe lastRecipe;
    private static final Object compostingRecipesKey = new Object();

    public void clear() {
        this.sizeLevel = 0;
        this.tempLevel = 0;
        this.timer = 0;
        this.lastRecipe = null;
    }

    public boolean updateCompostTower(CompostTowerBlockEntity controller) {
        if (controller.getLevel() == null) {
            return false;
        }
        BlockPos controllerPos = controller.getBlockPos();
        Level level = controller.getLevel();
        --this.updateRequired;
        int prevTemp = this.tempLevel;
        this.tempLevel = 0;
        for (int xOffset = 0; xOffset < controller.getWidth(); ++xOffset) {
            for (int zOffset = 0; zOffset < controller.getWidth(); ++zOffset) {
                float heat;
                BlockPos pos = controllerPos.offset(xOffset, -1, zOffset);
                BlockState blockState = level.getBlockState(pos);
                if (!(blockState.getBlock() instanceof BlazeBurnerBlock) && !blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) || !((heat = (float)BoilerHeaters.blazeBurner((Level)level, (BlockPos)pos, (BlockState)blockState)) > 0.0f)) continue;
                this.tempLevel = (int)((float)this.tempLevel + heat);
            }
        }
        this.tempLevel = Mth.clamp((int)this.tempLevel, (int)0, (int)8);
        return this.tempLevel != prevTemp;
    }

    public void tick(CompostTowerBlockEntity controller) {
        if (this.updateCompostTower(controller)) {
            controller.notifyUpdate();
        }
        if (controller.getLevel() == null) {
            return;
        }
        ItemStackHandler inputInventory = controller.inputInventory;
        CompostFluidTank fluidHandler = controller.tankInventory;
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (controller.getLevel().isClientSide) {
                return;
            }
            if (this.timer <= 0) {
                if (!CompostingRecipe.match(controller, this.lastRecipe) || !this.canOutput(inputInventory, fluidHandler, controller.getLevel().random)) {
                    this.updateLastRecipe(controller);
                    return;
                }
                CompostingRecipe.apply(controller, this.lastRecipe);
                controller.notifyUpdate();
            }
        } else {
            this.updateLastRecipe(controller);
        }
    }

    private boolean canOutput(ItemStackHandler outputInventory, IFluidHandler fluidHandler, RandomSource randomSource) {
        for (ItemStack outputStack : this.lastRecipe.rollResults(randomSource)) {
            if (outputStack.isEmpty() || ItemHandlerHelper.insertItemStacked((IItemHandler)outputInventory, (ItemStack)outputStack, (boolean)true).isEmpty()) continue;
            return false;
        }
        for (FluidStack fluidStack : this.lastRecipe.getFluidResults()) {
            if (fluidStack.isEmpty() || fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) >= fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    public boolean evaluate(CompostTowerBlockEntity tower) {
        if (tower.getLevel() == null) {
            return false;
        }
        int sizeLevelBefore = this.sizeLevel;
        this.sizeLevel = tower.getWidth() * tower.getHeight() * tower.getWidth() / 4;
        this.sizeLevel = Mth.clamp((int)this.sizeLevel, (int)0, (int)8);
        return sizeLevelBefore != this.sizeLevel;
    }

    public void read(CompoundTag compound, boolean ignoredClientPacket) {
        this.sizeLevel = compound.getInt("sizeCount");
        this.tempLevel = compound.getInt("tempCount");
    }

    public void write(CompoundTag compound, boolean ignoredClientPacket) {
        compound.putInt("sizeCount", this.sizeLevel);
        compound.putInt("tempCount", this.tempLevel);
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.sizeLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.tempLevel, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect("compost_tower." + label, new Object[0]).withStyle(style1).append((Component)Lang.translateDirect("compost_tower." + label + "_dots", new Object[0]).withStyle(style2)).append((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        int clamped = Mth.clamp((int)level, (int)0, (int)8);
        return Component.literal((String)("\u2588".repeat(clamped) + "\u2591".repeat(8 - clamped)));
    }

    private MutableComponent barComponent(int level) {
        return Component.empty().append((Component)this.bars(Math.max(0, -1), ChatFormatting.DARK_GREEN)).append((Component)this.bars(0, ChatFormatting.GREEN)).append((Component)this.bars(Math.max(0, level - 0), ChatFormatting.DARK_GREEN)).append((Component)this.bars(Math.max(0, 8 - level), ChatFormatting.DARK_RED)).append((Component)this.bars(Math.max(0, Math.min(10, 2)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.literal((String)Strings.repeat((char)'|', (int)level)).withStyle(format);
    }

    @NotNull
    public MutableComponent getLevelComponent() {
        int compostTowerLevel = Math.min(this.sizeLevel, this.tempLevel);
        if (compostTowerLevel == 0) {
            return Lang.translateDirect("compost_tower.idle", new Object[0]);
        }
        return compostTowerLevel >= 8 ? Lang.translateDirect("compost_tower.max_lvl", new Object[0]) : Lang.translateDirect("compost_tower.lvl", new Object[0]).append(String.valueOf(compostTowerLevel));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean ignoredIsPlayerSneaking) {
        MutableComponent indent = Component.literal((String)"    ");
        MutableComponent indent2 = Component.literal((String)"     ");
        tooltip.add((Component)indent.copy().append((Component)Lang.translateDirect("compost_tower.status", new Object[0]).append((Component)this.getLevelComponent().withStyle(ChatFormatting.GREEN))));
        tooltip.add((Component)indent2.copy().append((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.copy().append((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        return true;
    }

    public int getProcessingSpeed() {
        if (Math.min(this.sizeLevel, this.tempLevel) == 0) {
            return 16;
        }
        return (int)((double)this.sizeLevel / 8.0 * (double)this.tempLevel / 8.0 * 512.0);
    }

    private void updateLastRecipe(CompostTowerBlockEntity controller) {
        if (CompostingRecipe.match(controller, this.lastRecipe)) {
            this.timer = this.lastRecipe.getProcessingDuration();
            controller.notifyUpdate();
            return;
        }
        ArrayList<CompostingRecipe> list = new ArrayList<CompostingRecipe>();
        try {
            RecipeTrie trie = RecipeTrieFinder.get((Object)this.getRecipeCacheKey(), (Level)controller.getLevel(), this::matchStaticFilters);
            Set availableVariants = RecipeTrie.getVariants((IItemHandler)controller.inputInventory, (IFluidHandler)controller.tankInventory);
            for (Recipe r : trie.lookup(availableVariants)) {
                if (!CompostingRecipe.match(controller, r)) continue;
                list.add((CompostingRecipe)r);
            }
        }
        catch (Exception e) {
            list.clear();
            for (RecipeHolder r : RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)controller.getLevel(), this::matchStaticFilters)) {
                Recipe recipe = r.value();
                if (!CompostingRecipe.match(controller, recipe)) continue;
                list.add((CompostingRecipe)recipe);
            }
        }
        list.sort((r1, r2) -> r2.getIngredients().size() - r1.getIngredients().size());
        if (!list.isEmpty()) {
            this.lastRecipe = (CompostingRecipe)((Object)list.get(0));
            this.timer = this.lastRecipe.getProcessingDuration();
        } else {
            this.lastRecipe = null;
            this.timer = 100;
        }
        controller.notifyUpdate();
    }

    private boolean matchStaticFilters(RecipeHolder<?> recipe) {
        return true;
    }

    protected Object getRecipeCacheKey() {
        return compostingRecipesKey;
    }
}

