/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tea;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CompostTeaBottleItem
extends Item {
    public CompostTeaBottleItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        if (this.applyBonemealLike(level, pos)) {
            if (!level.isClientSide) {
                if (player != null) {
                    player.getCooldowns().addCooldown((Item)this, 20);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                        ItemStack emptyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                        if (!player.getInventory().add(emptyBottle)) {
                            player.drop(emptyBottle, false);
                        }
                    }
                }
                level.levelEvent(1505, pos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private boolean applyBonemealLike(Level level, BlockPos pos) {
        BonemealableBlock growable;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, state)) {
            RandomSource rand;
            if (!level.isClientSide && growable.isBonemealSuccess(level, rand = level.getRandom(), pos, state)) {
                growable.performBonemeal((ServerLevel)level, rand, pos, state);
            }
            return true;
        }
        return false;
    }
}

