/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.forsteri.ratatouille.compat.jei.category.animations.AnimatedCompostTower;
import org.forsteri.ratatouille.content.compost_tower.CompostingRecipe;

public class CompostingCategory
extends CreateRecipeCategory<CompostingRecipe> {
    private static final int SLOT = 18;
    private static final int COLUMNS = 3;
    private static final int CENTER_Y = 57;
    private final AnimatedCompostTower tower = new AnimatedCompostTower();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public CompostingCategory(CreateRecipeCategory.Info<CompostingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompostingRecipe recipe, IFocusGroup focuses) {
        int padding;
        ArrayList<SlotEntry> inputs = new ArrayList<SlotEntry>();
        for (Pair pair : ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients())) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack is : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = is.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            inputs.add(SlotEntry.item(stacks));
        }
        recipe.getFluidIngredients().forEach(fi -> Arrays.stream(fi.getFluids()).forEach(fs -> inputs.add(SlotEntry.fluid(fs))));
        ArrayList<SlotEntry> outputs = new ArrayList<SlotEntry>();
        recipe.getRollableResults().forEach(r -> outputs.add(SlotEntry.item(List.of(r.getStack()))));
        recipe.getFluidResults().forEach(fs -> outputs.add(SlotEntry.fluid(fs)));
        int bgWidth = this.getBackground().getWidth();
        int inputX = padding = 8;
        int outputX = bgWidth - 54 - padding;
        this.layoutMixedSlots(builder, inputs, RecipeIngredientRole.INPUT, inputX);
        this.layoutMixedSlots(builder, outputs, RecipeIngredientRole.OUTPUT, outputX);
    }

    private void layoutMixedSlots(IRecipeLayoutBuilder builder, List<SlotEntry> entries, RecipeIngredientRole role, int baseX) {
        int rows = (int)Math.ceil((double)entries.size() / 3.0);
        int startY = 57 - rows * 18 / 2;
        for (int row = 0; row < rows; ++row) {
            int rowStart = row * 3;
            int rowEnd = Math.min(rowStart + 3, entries.size());
            int countInRow = rowEnd - rowStart;
            int rowWidth = countInRow * 18;
            int startX = baseX + (54 - rowWidth) / 2;
            for (int i = 0; i < countInRow; ++i) {
                int index = rowStart + i;
                int x = startX + i * 18;
                int y = startY + row * 18;
                SlotEntry entry = entries.get(index);
                IRecipeSlotBuilder slot = builder.addSlot(role, x, y).setBackground(CompostingCategory.getRenderedSlot(), -1, -1);
                if (entry.isFluid()) {
                    FluidStack fs = entry.fluid;
                    slot.setFluidRenderer((long)fs.getAmount(), false, 16, 16).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fs);
                    continue;
                }
                slot.addItemStacks(entry.items);
            }
        }
    }

    public void draw(CompostingRecipe recipe, IRecipeSlotsView view, GuiGraphics g, double mouseX, double mouseY) {
        PoseStack pose = g.pose();
        int centerX = this.getBackground().getWidth() / 2;
        pose.pushPose();
        pose.translate((float)(centerX - 10), -15.0f, 0.0f);
        this.getBlockShadow().render(g, -17, 54);
        AllGuiTextures.JEI_ARROW.render(g, -11, 66);
        pose.pushPose();
        pose.translate(-6.0f, 20.0f, -7.0f);
        this.heater.withHeat(recipe.getRequiredHeat().visualizeAsBlazeBurner()).draw(g);
        pose.popPose();
        pose.pushPose();
        pose.translate(-6.0f, 0.0f, 0.0f);
        this.tower.draw(g);
        pose.popPose();
        pose.popPose();
    }

    protected AllGuiTextures getBlockShadow() {
        return AllGuiTextures.JEI_LIGHT;
    }

    private static class SlotEntry {
        final List<ItemStack> items;
        final FluidStack fluid;

        private SlotEntry(List<ItemStack> items, FluidStack fluid) {
            this.items = items;
            this.fluid = fluid;
        }

        static SlotEntry item(List<ItemStack> stacks) {
            return new SlotEntry(stacks, null);
        }

        static SlotEntry fluid(FluidStack stack) {
            return new SlotEntry(null, stack);
        }

        boolean isFluid() {
            return this.fluid != null;
        }
    }
}

