/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.forsteri.ratatouille.Ratatouille;
import org.forsteri.ratatouille.compat.jei.category.BakeSmokingCategory;
import org.forsteri.ratatouille.compat.jei.category.BakingCategory;
import org.forsteri.ratatouille.compat.jei.category.CompostingCategory;
import org.forsteri.ratatouille.compat.jei.category.DemoldingCategory;
import org.forsteri.ratatouille.compat.jei.category.FreezingCategory;
import org.forsteri.ratatouille.compat.jei.category.SqueezingCategory;
import org.forsteri.ratatouille.compat.jei.category.ThreshingCategory;
import org.forsteri.ratatouille.content.compost_tower.CompostingRecipe;
import org.forsteri.ratatouille.content.demolder.DemoldingRecipe;
import org.forsteri.ratatouille.content.frozen_block.FreezingRecipe;
import org.forsteri.ratatouille.content.oven.BakingRecipe;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezingRecipe;
import org.forsteri.ratatouille.content.thresher.ThreshingRecipe;
import org.forsteri.ratatouille.entry.CRBlocks;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class RatatouilleJei
implements IModPlugin {
    private static final ResourceLocation ID = Ratatouille.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.allCategories.clear();
        CreateRecipeCategory<ThreshingRecipe> threshing = this.builder(ThreshingRecipe.class).addTypedRecipes(CRRecipeTypes.THRESHING::getType).catalyst(() -> CRBlocks.THRESHER.get()).itemIcon((ItemLike)CRBlocks.THRESHER.get()).emptyBackground(177, 53).build("threshing", (CreateRecipeCategory.Factory<ThreshingRecipe>)((CreateRecipeCategory.Factory)ThreshingCategory::new));
        CreateRecipeCategory<SqueezingRecipe> squeezing = this.builder(SqueezingRecipe.class).addTypedRecipes(CRRecipeTypes.SQUEEZING::getType).catalyst(() -> ((BlockEntry)AllBlocks.MECHANICAL_PRESS).get()).catalyst(() -> CRBlocks.SQUEEZE_BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)CRBlocks.SQUEEZE_BASIN.get()).emptyBackground(177, 103).build("squeezing", (CreateRecipeCategory.Factory<SqueezingRecipe>)((CreateRecipeCategory.Factory)SqueezingCategory::new));
        CreateRecipeCategory<DemoldingRecipe> demolding = this.builder(DemoldingRecipe.class).addTypedRecipes(CRRecipeTypes.DEMOLDING::getType).catalyst(() -> CRBlocks.MECHANICAL_DEMOLDER.get()).emptyBackground(177, 70).build("demolding", (CreateRecipeCategory.Factory<DemoldingRecipe>)((CreateRecipeCategory.Factory)DemoldingCategory::new));
        CreateRecipeCategory<BakingRecipe> baking = this.builder(BakingRecipe.class).addTypedRecipes(CRRecipeTypes.BAKING::getType).catalyst(() -> CRBlocks.OVEN.get()).itemIcon((ItemLike)CRBlocks.OVEN.get()).emptyBackground(178, 72).build("baking", (CreateRecipeCategory.Factory<BakingRecipe>)((CreateRecipeCategory.Factory)BakingCategory::new));
        CreateRecipeCategory<SmokingRecipe> bakeSmoking = this.builder(SmokingRecipe.class).addTypedRecipes(() -> net.minecraft.world.item.crafting.RecipeType.SMOKING).catalyst(() -> CRBlocks.OVEN.get()).doubleItemIcon((ItemLike)CRBlocks.OVEN.get(), (ItemLike)Items.CAMPFIRE).emptyBackground(178, 72).build("bakesmoking", (CreateRecipeCategory.Factory<SmokingRecipe>)((CreateRecipeCategory.Factory)BakeSmokingCategory::new));
        CreateRecipeCategory<FreezingRecipe> freezing = this.builder(FreezingRecipe.class).addTypedRecipes(CRRecipeTypes.FREEZING::getType).catalyst(() -> CRBlocks.FROZEN_BLOCK.get()).itemIcon((ItemLike)CRBlocks.FROZEN_BLOCK.get()).emptyBackground(178, 72).build("freezing", (CreateRecipeCategory.Factory<FreezingRecipe>)((CreateRecipeCategory.Factory)FreezingCategory::new));
        CreateRecipeCategory<CompostingRecipe> composting = this.builder(CompostingRecipe.class).addTypedRecipes(CRRecipeTypes.COMPOSTING::getType).catalyst(() -> CRBlocks.COMPOST_TOWER_BLOCK.get()).itemIcon((ItemLike)CRBlocks.COMPOST_TOWER_BLOCK.get()).emptyBackground(178, 72).build("composting", (CreateRecipeCategory.Factory<CompostingRecipe>)((CreateRecipeCategory.Factory)CompostingCategory::new));
        this.allCategories.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    private class CategoryBuilder<T extends Recipe<? extends RecipeInput>> {
        private final Class<? extends T> recipeClass;
        private final List<Consumer<List<RecipeHolder<T>>>> recipeListConsumers = new ArrayList<Consumer<List<RecipeHolder<T>>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public <I extends RecipeInput, R extends Recipe<I>> CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<R>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (this.recipeClass.isInstance(recipe.value())) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<RecipeHolder<T>>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).asItem()));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(Ratatouille.asResource(name), this.recipeClass), (Component)Lang.translateDirect("recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            RatatouilleJei.this.allCategories.add(category);
            return category;
        }
    }
}

