/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.block.salvager.SalvagerBlockEntity;
import net.silentchaos512.gear.setup.SgMenuTypes;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;

public class SalvagerContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData fields;

    public SalvagerContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, (Container)new SimpleContainer(SalvagerBlockEntity.INVENTORY_SIZE), (ContainerData)new SimpleContainerData(1));
    }

    public SalvagerContainer(int id, Inventory playerInventory, Container inventory, ContainerData fields) {
        super((MenuType)SgMenuTypes.SALVAGER.get(), id);
        this.inventory = inventory;
        this.fields = fields;
        this.addSlot(new Slot(inventory, 0, 9, 35));
        int index = 1;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.addSlot((Slot)new SlotOutputOnly(inventory, index, 62 + 18 * x, 17 + 18 * y));
                ++index;
            }
        }
        InventoryUtils.createPlayerSlots((Inventory)playerInventory, (int)8, (int)84).forEach(x$0 -> this.addSlot((Slot)x$0));
        this.addDataSlots(this.fields);
    }

    public int getProgressArrowScale() {
        int progress = this.fields.get(0);
        return progress != 0 ? progress * 24 / SalvagerBlockEntity.BASE_WORK_TIME : 0;
    }

    public void addSlotListener(ContainerListener listener) {
        super.addSlotListener(listener);
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int size;
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int startPlayer = size = this.inventory.getContainerSize();
            int endPlayer = size + 27;
            int startHotbar = size + 27;
            int endHotbar = size + 36;
            if (index >= 1 && index < size ? !this.moveItemStackTo(stack1, startPlayer, endHotbar, true) : (index >= size && this.inventory.canPlaceItem(0, stack1) ? !this.moveItemStackTo(stack1, 0, 1, false) : (index >= startPlayer && index < endPlayer ? !this.moveItemStackTo(stack1, startHotbar, endHotbar, false) : (index >= startHotbar && index < endHotbar ? !this.moveItemStackTo(stack1, startPlayer, endPlayer, false) : !this.moveItemStackTo(stack1, startPlayer, endHotbar, false))))) {
                return ItemStack.EMPTY;
            }
            if (stack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack1);
        }
        return stack;
    }
}

