/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.integration;

import dev.ftb.mods.ftbessentials.integration.PermissionsProvider;
import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.server.level.ServerPlayer;

public class LuckPermsIntegration
implements PermissionsProvider {
    @Override
    public int getInt(ServerPlayer player, int def, String node) {
        return Math.max(LuckPermsIntegration.getMetaData(player.getUUID(), node).map(Integer::parseInt).orElse(def), 0);
    }

    @Override
    public boolean getBool(ServerPlayer player, boolean def, String node) {
        return LuckPermsIntegration.getMetaData(player.getUUID(), node).map(Boolean::parseBoolean).orElse(def);
    }

    private static Optional<String> getMetaData(UUID uuid, String meta) {
        LuckPerms luckperms = LuckPermsProvider.get();
        Optional<String> metaValue = Optional.empty();
        try {
            Optional context;
            User user = luckperms.getUserManager().getUser(uuid);
            if (user != null && (context = luckperms.getContextManager().getQueryOptions(user)).isPresent()) {
                metaValue = Optional.ofNullable(user.getCachedData().getMetaData((QueryOptions)context.get()).getMetaValue(meta));
            }
        }
        catch (IllegalStateException e) {
            System.err.println("Error on fetching user with luckperms");
            System.err.println(e.getMessage());
        }
        return metaValue;
    }
}

