/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.groups.AdminCommands;
import dev.ftb.mods.ftbessentials.commands.groups.ChatCommands;
import dev.ftb.mods.ftbessentials.commands.groups.CheatCommands;
import dev.ftb.mods.ftbessentials.commands.groups.FeatureCommands;
import dev.ftb.mods.ftbessentials.commands.groups.MiscCommands;
import dev.ftb.mods.ftbessentials.commands.groups.TeleportingCommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTBCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTBCommands.class);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LOGGER.debug("Registering FTB Essentials commands");
        List<FTBCommand> commandGroups = Stream.of(FeatureCommands.COMMANDS, AdminCommands.COMMANDS, ChatCommands.COMMANDS, CheatCommands.COMMANDS, MiscCommands.COMMANDS, TeleportingCommands.COMMANDS).flatMap(Collection::stream).toList();
        FTBCommands.registerCommandsToDispatcher(dispatcher, commandGroups);
    }

    private static void registerCommandsToDispatcher(CommandDispatcher<CommandSourceStack> dispatcher, List<FTBCommand> commands) {
        LiteralArgumentBuilder namespace = Commands.literal((String)"ftbessentials");
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> commandStack = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        for (FTBCommand fTBCommand : commands) {
            if (!fTBCommand.enabled()) continue;
            for (LiteralArgumentBuilder<CommandSourceStack> builder : fTBCommand.register()) {
                if (((Boolean)FTBEConfig.REGISTER_TO_NAMESPACE.get()).booleanValue()) {
                    namespace.then(builder);
                    commandStack.add(builder);
                    continue;
                }
                dispatcher.register(builder);
            }
        }
        if (((Boolean)FTBEConfig.REGISTER_TO_NAMESPACE.get()).booleanValue()) {
            if (((Boolean)FTBEConfig.REGISTER_ALIAS_AS_WELL_AS_NAMESPACE.get()).booleanValue()) {
                for (LiteralArgumentBuilder literalArgumentBuilder : commandStack) {
                    dispatcher.register(literalArgumentBuilder);
                }
            }
            dispatcher.register(namespace);
        }
    }
}

