/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.DankStats;

public class DankSavedData
extends SavedData {
    protected final ServerLevel level;
    private final int frequency;
    DankInventory cache;
    DankStats stats = DankStats.zero;
    CompoundTag tag = new CompoundTag();

    public DankSavedData(ServerLevel level, int frequency) {
        this.level = level;
        this.frequency = frequency;
    }

    public static SavedData.Factory<DankSavedData> factory(ServerLevel pLevel, int frequency) {
        return new SavedData.Factory(() -> new DankSavedData(pLevel, frequency), (tag, p_324123_) -> DankSavedData.loadStatic(tag, pLevel, frequency), DataFixTypes.SAVED_DATA_RAIDS);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putString("Stats", this.stats.name());
        if (this.cache != null) {
            compoundTag.put("contents", (Tag)this.cache.save(provider));
        }
        return compoundTag;
    }

    public static DankSavedData getOrCreate(int id, MinecraftServer server) {
        DankSavedData tankSavedData = DankSavedData.get(id, server);
        if (tankSavedData != null) {
            return tankSavedData;
        }
        ServerLevel overworld = server.overworld();
        return (DankSavedData)overworld.getDataStorage().computeIfAbsent(DankSavedData.factory(overworld, id), "dankstorage/" + id);
    }

    @Nullable
    public static DankSavedData get(int id, MinecraftServer server) {
        if (id <= -1) {
            throw new RuntimeException("Invalid frequency: " + id);
        }
        ServerLevel overworld = server.overworld();
        return (DankSavedData)overworld.getDataStorage().get(DankSavedData.factory(overworld, id), "dankstorage/" + id);
    }

    public DankInventory getOrCreateInventory() {
        if (this.cache == null) {
            this.cache = Services.PLATFORM.createInventory(this.stats, this);
            this.cache.load((HolderLookup.Provider)this.level.registryAccess(), this.tag);
        }
        if (this.cache.items.size() != this.stats.slots) {
            this.cache.setTo(this.stats);
        }
        return this.cache;
    }

    public void setStats(DankStats stats) {
        this.stats = stats;
        this.setDirty();
    }

    public DankStats getStats() {
        return this.stats;
    }

    protected void load(CompoundTag compoundTag) {
        this.stats = compoundTag.contains("Stats") ? DankStats.valueOf(compoundTag.getString("Stats")) : DankStats.zero;
        this.tag = compoundTag.getCompound("contents");
    }

    public static DankSavedData loadStatic(CompoundTag compoundTag, ServerLevel level, int frequency) {
        DankSavedData tankSavedData = new DankSavedData(level, frequency);
        tankSavedData.load(compoundTag);
        return tankSavedData;
    }

    public boolean clear() {
        DankInventory dankInventory = this.getOrCreateInventory();
        return true;
    }
}

