/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import tfar.dankstorage.init.ModDataComponentTypes;
import tfar.dankstorage.init.ModRecipeSerializers;

public class UpgradeRecipe
extends ShapedRecipe {
    protected static final List<DataComponentType> types = new ArrayList<DataComponentType>();

    public UpgradeRecipe(ShapedRecipe recipe) {
        super("dank", recipe.category(), recipe.pattern, recipe.getResultItem(null));
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack newBag = super.assemble(inv, access).copy();
        ItemStack oldBag = inv.getItem(4);
        if (oldBag.getComponents().isEmpty()) {
            return newBag;
        }
        for (DataComponentType type : types) {
            if (!oldBag.has(type)) continue;
            newBag.set(type, oldBag.get(type));
        }
        return newBag;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.upgrade;
    }

    static {
        types.add(ModDataComponentTypes.FREQUENCY);
        types.add(ModDataComponentTypes.PICKUP_MODE);
        types.add(ModDataComponentTypes.USE_TYPE);
        types.add(ModDataComponentTypes.SELECTED);
        types.add(ModDataComponentTypes.OREDICT);
    }
}

