/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.client.S2CContentsForDisplayPacket;
import tfar.dankstorage.network.server.C2SModPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.world.DankSavedData;

public class C2SRequestContentsPacket
implements C2SModPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SRequestContentsPacket> STREAM_CODEC = StreamCodec.ofMember(C2SRequestContentsPacket::write, C2SRequestContentsPacket::new);
    public static final CustomPacketPayload.Type<C2SRequestContentsPacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(C2SRequestContentsPacket.class));
    private final int frequency;

    public C2SRequestContentsPacket(int frequency) {
        this.frequency = frequency;
    }

    public C2SRequestContentsPacket(FriendlyByteBuf buf) {
        this.frequency = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.frequency);
    }

    public static void send(int frequency) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(frequency);
        Services.PLATFORM.sendToServer(new C2SRequestContentsPacket(frequency));
    }

    @Override
    public void handleServer(ServerPlayer player) {
        DankInventory dankInventoryForge = DankSavedData.get(this.frequency, player.server).getOrCreateInventory();
        Services.PLATFORM.sendToClient(new S2CContentsForDisplayPacket(dankInventoryForge.getContents()), player);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

