/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.client;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.CommonClient;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.client.S2CModPacket;
import tfar.dankstorage.utils.SerializationHelper;

public class S2CSyncSelectedDankItemPacket
implements S2CModPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CSyncSelectedDankItemPacket> STREAM_CODEC = StreamCodec.ofMember(S2CSyncSelectedDankItemPacket::write, S2CSyncSelectedDankItemPacket::new);
    public static final CustomPacketPayload.Type<S2CSyncSelectedDankItemPacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(S2CSyncSelectedDankItemPacket.class));
    private final ItemStack stack;

    public S2CSyncSelectedDankItemPacket(ItemStack stack) {
        this.stack = stack;
    }

    public S2CSyncSelectedDankItemPacket(RegistryFriendlyByteBuf buf) {
        this.stack = SerializationHelper.readExtendedItemStack(buf);
    }

    @Override
    public void handleClient() {
        Player player = CommonClient.getLocalPlayer();
        if (player != null) {
            // empty if block
        }
    }

    public void write(RegistryFriendlyByteBuf buf) {
        SerializationHelper.writeExtendedItemStack(buf, this.stack);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

