/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.client;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.CommonClient;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.client.S2CModPacket;

public class S2CSendGhostSlotPacket
implements S2CModPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CSendGhostSlotPacket> STREAM_CODEC = StreamCodec.ofMember(S2CSendGhostSlotPacket::write, S2CSendGhostSlotPacket::new);
    public static final CustomPacketPayload.Type<S2CSendGhostSlotPacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(S2CSendGhostSlotPacket.class));
    int windowId;
    int slot;
    ItemStack stack;

    public S2CSendGhostSlotPacket(int windowId, int slot, ItemStack stack) {
        this.windowId = windowId;
        this.slot = slot;
        this.stack = stack;
    }

    public S2CSendGhostSlotPacket(RegistryFriendlyByteBuf buf) {
        this.windowId = buf.readInt();
        this.slot = buf.readInt();
        this.stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.slot);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.stack);
    }

    @Override
    public void handleClient() {
        AbstractContainerMenu abstractContainerMenu;
        Player player = CommonClient.getLocalPlayer();
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof DankMenu) {
            DankMenu dankMenu = (DankMenu)abstractContainerMenu;
            if (this.windowId == player.containerMenu.containerId) {
                dankMenu.dankInventory.setGhostItem(this.slot, this.stack);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

