/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.client;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.CommonClient;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.client.S2CModPacket;
import tfar.dankstorage.utils.SerializationHelper;

public class S2CSendExtendedSlotChangePacket
implements S2CModPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CSendExtendedSlotChangePacket> STREAM_CODEC = StreamCodec.ofMember(S2CSendExtendedSlotChangePacket::write, S2CSendExtendedSlotChangePacket::new);
    public static final CustomPacketPayload.Type<S2CSendExtendedSlotChangePacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(S2CSendExtendedSlotChangePacket.class));
    int windowId;
    int stateID;
    int slot;
    ItemStack stack;

    public S2CSendExtendedSlotChangePacket(int windowId, int stateID, int slot, ItemStack stack) {
        this.windowId = windowId;
        this.stateID = stateID;
        this.slot = slot;
        this.stack = stack;
    }

    public S2CSendExtendedSlotChangePacket(RegistryFriendlyByteBuf buf) {
        this.windowId = buf.readByte();
        this.stateID = buf.readVarInt();
        this.slot = buf.readShort();
        this.stack = SerializationHelper.readExtendedItemStack(buf);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeVarInt(this.stateID);
        buf.writeShort(this.slot);
        SerializationHelper.writeExtendedItemStack(buf, this.stack);
    }

    @Override
    public void handleClient() {
        Player player = CommonClient.getLocalPlayer();
        if (player != null && player.containerMenu instanceof DankMenu && this.windowId == player.containerMenu.containerId) {
            player.containerMenu.setItem(this.slot, this.stateID, this.stack);
        }
    }

    public CustomPacketPayload.Type<S2CSendExtendedSlotChangePacket> type() {
        return TYPE;
    }
}

