/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.menu;

import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.network.client.AdvancedContainerSetDataPayload;
import tfar.dankstorage.network.client.S2CInitialSyncContainerPacket;
import tfar.dankstorage.network.client.S2CSendExtendedSlotChangePacket;
import tfar.dankstorage.platform.Services;

public class CustomSync
implements ContainerSynchronizer {
    private final ServerPlayer player;

    public CustomSync(ServerPlayer player) {
        this.player = player;
    }

    public void sendInitialData(AbstractContainerMenu abstractContainerMenu, NonNullList<ItemStack> stacks, ItemStack carried, int[] is) {
        Services.PLATFORM.sendToClient(new S2CInitialSyncContainerPacket(abstractContainerMenu.containerId, abstractContainerMenu.incrementStateId(), stacks, carried), this.player);
        for (int i = 0; i < is.length; ++i) {
            this.broadcastDataValue(abstractContainerMenu, i, is[i]);
        }
    }

    public void sendSlotChange(AbstractContainerMenu abstractContainerMenu, int slot, ItemStack stack) {
        Services.PLATFORM.sendToClient(new S2CSendExtendedSlotChangePacket(abstractContainerMenu.containerId, abstractContainerMenu.incrementStateId(), slot, stack), this.player);
    }

    public void sendCarriedChange(AbstractContainerMenu abstractContainerMenu, ItemStack stack) {
        this.broadcastCarriedItem(stack);
    }

    public void sendDataChange(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        this.broadcastDataValue(abstractContainerMenu, i, j);
    }

    private void broadcastDataValue(AbstractContainerMenu abstractContainerMenu, int slot, int value) {
        Services.PLATFORM.sendToClient(new AdvancedContainerSetDataPayload((byte)abstractContainerMenu.containerId, (short)slot, value), this.player);
    }

    private void broadcastCarriedItem(ItemStack itemStack) {
        this.player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, this.player.containerMenu.incrementStateId(), -1, itemStack));
    }
}

