/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.inventory.SortingType;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.SerializationHelper;
import tfar.dankstorage.world.DankSavedData;

public class DankInventory
implements ContainerData {
    private final DankSavedData data;
    protected static String GHOST = "GhostItems";
    public NonNullList<ItemStack> items;
    protected NonNullList<ItemStack> ghostItems;
    public int capacity;
    private boolean frequencyLocked = true;
    protected int textColor = -1;
    public static final int TXT_COLOR = 0;
    public static final int FREQ_LOCK = 1;
    public static final int SORTING_TYPE = 2;
    public static final int AUTO_SORT = 3;
    public static final int DATA_SLOTS = 4;
    private SortingType sortingType = SortingType.descending;
    private boolean autoSort = true;
    protected boolean needsSort;

    public DankInventory(DankStats stats, DankSavedData data) {
        this(stats.slots, stats.stacklimit, data);
    }

    public DankInventory(int slots, int capacity, @Nullable DankSavedData data) {
        this.items = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        this.ghostItems = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        this.capacity = capacity;
        this.data = data;
    }

    public static DankInventory createDummy(DankStats dankStats) {
        return Services.PLATFORM.createInventory(dankStats, null);
    }

    public void setSortingType(SortingType sortingType) {
        this.sortingType = sortingType;
        this.setDirty(true);
    }

    public SortingType getSortingType() {
        return this.sortingType;
    }

    public ItemStack getGhostItem(int slot) {
        return (ItemStack)this.getGhostItems().get(slot);
    }

    public boolean frequencyLocked() {
        return this.frequencyLocked;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void toggleFrequencyLock() {
        this.frequencyLocked = !this.frequencyLocked;
        this.setDirty(false);
    }

    public void setItemDank(int slot, ItemStack stack) {
        if (this.inBounds(slot)) {
            this.items.set(slot, (Object)stack);
            this.setDirty(true);
        } else {
            this.warnOutOfBounds(slot);
        }
    }

    boolean inBounds(int index) {
        return index >= 0 && index < this.slotCount();
    }

    void warnOutOfBounds(int slot) {
        DankStorage.LOG.warn("Index out of bounds accessed, {} in size {}", (Object)slot, (Object)this.slotCount());
    }

    public ItemStack getItemDank(int slot) {
        if (this.inBounds(slot)) {
            return (ItemStack)this.items.get(slot);
        }
        this.warnOutOfBounds(slot);
        return ItemStack.EMPTY;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (!this.inBounds(slot)) {
            return false;
        }
        boolean checkGhostItem = !this.hasGhostItem(slot) || this.getGhostItem(slot).getItem() == stack.getItem();
        return !stack.is(ModTags.BLACKLISTED_STORAGE) && checkGhostItem;
    }

    public void setGhostItem(int slot, ItemStack stack) {
        if (this.inBounds(slot)) {
            this.getGhostItems().set(slot, (Object)stack);
        } else {
            this.warnOutOfBounds(slot);
        }
    }

    public NonNullList<ItemStack> getContents() {
        return this.items;
    }

    public void setItemsDank(NonNullList<ItemStack> stacks) {
        this.items = stacks;
    }

    protected NonNullList<ItemStack> getGhostItems() {
        return this.ghostItems;
    }

    public void setGhostItems(NonNullList<ItemStack> ghostItems) {
        this.ghostItems = ghostItems;
    }

    public int get(int slot) {
        return switch (slot) {
            case 0 -> this.textColor;
            case 1 -> {
                if (this.frequencyLocked) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> this.sortingType.ordinal();
            case 3 -> {
                if (this.autoSort) {
                    yield 1;
                }
                yield 0;
            }
            default -> -999;
        };
    }

    public void set(int slot, int value) {
        switch (slot) {
            case 0: {
                this.textColor = value;
                break;
            }
            case 1: {
                this.frequencyLocked = value != 0;
                break;
            }
            case 2: {
                this.sortingType = SortingType.values()[value];
                break;
            }
            case 3: {
                this.autoSort = value != 0;
            }
        }
        this.setDirty(false);
    }

    public int getCount() {
        return 4;
    }

    ItemStack addItemDank(int slot, ItemStack stack) {
        return this.insertStack(slot, stack, false);
    }

    public ItemStack insertStack(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.canPlaceItem(slot, stack)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.items.get(slot);
        int limit = this.getMaxStackSizeSensitive(stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.items.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.setDirty(true);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack extractStack(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = (ItemStack)this.items.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.items.set(slot, (Object)ItemStack.EMPTY);
                this.setDirty(true);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.items.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.setDirty(true);
        }
        return existing.copyWithCount(toExtract);
    }

    public ItemStack extractStackTarget(int amount, boolean simulate, ItemStack target) {
        if (amount == 0 || target.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int remaining = amount;
        int extracted = 0;
        for (int i = 0; i < this.slotCount(); ++i) {
            ItemStack slotStack = this.getItemDank(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)target, (ItemStack)slotStack)) continue;
            ItemStack stack = this.extractStack(i, remaining, simulate);
            extracted += stack.getCount();
            if ((remaining -= stack.getCount()) <= 0) break;
        }
        return target.copyWithCount(extracted);
    }

    ItemStack insertStackGeneral(ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = stack.copy();
        for (int i = 0; i < this.slotCount() && !(remainder = this.insertStack(i, remainder, simulate)).isEmpty(); ++i) {
        }
        return remainder;
    }

    public int getMaxStackSizeSensitive(ItemStack stack) {
        return stack.is(ModTags.UNSTACKABLE) ? 1 : this.getMaxStackSizeDank();
    }

    public void sort() {
        ArrayList<ItemStack> gathered = new ArrayList<ItemStack>();
        HashSet<ItemStack> lockedItems = new HashSet<ItemStack>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            ItemStack ghost = (ItemStack)this.ghostItems.get(i);
            if (stack.isEmpty()) continue;
            CommonUtils.merge(gathered, stack.copy());
            boolean unique = true;
            for (ItemStack stack1 : lockedItems) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack)) continue;
                unique = false;
                break;
            }
            if (!unique || ghost.isEmpty()) continue;
            lockedItems.add(stack.copyWithCount(1));
        }
        gathered.sort(this.sortingType.comparator);
        this.items.clear();
        this.ghostItems.clear();
        int slotId = 0;
        for (int i = 0; i < gathered.size(); ++i) {
            int tankSize;
            ItemStack stack = (ItemStack)gathered.get(i);
            int count = stack.getCount();
            if (count > (tankSize = this.capacity)) {
                int fullStacks = count / tankSize;
                int partialStack = count - fullStacks * tankSize;
                for (int j = 0; j < fullStacks; ++j) {
                    this.items.set(slotId, (Object)stack.copyWithCount(tankSize));
                    if (DankInventory.anyMatch(stack, lockedItems)) {
                        this.ghostItems.set(slotId, (Object)stack.copyWithCount(1));
                    }
                    ++slotId;
                }
                if (partialStack <= 0) continue;
                this.items.set(slotId, (Object)stack.copyWithCount(partialStack));
                if (DankInventory.anyMatch(stack, lockedItems)) {
                    this.ghostItems.set(slotId, (Object)stack.copyWithCount(1));
                }
                ++slotId;
                continue;
            }
            this.items.set(slotId, (Object)stack);
            if (DankInventory.anyMatch(stack, lockedItems)) {
                this.ghostItems.set(slotId, (Object)stack.copyWithCount(1));
            }
            ++slotId;
        }
        this.setDirty(false);
    }

    static boolean anyMatch(ItemStack stack, Set<ItemStack> stacks) {
        for (ItemStack stack1 : stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void compress(ServerLevel level, @Nullable ServerPlayer player) {
        int i;
        List<ItemStack> allItems = this.getUniqueItems();
        ArrayList<Pair<ItemStack, ItemStack>> craftingResults = new ArrayList<Pair<ItemStack, ItemStack>>();
        for (i = 0; i < allItems.size(); ++i) {
            ItemStack stack = allItems.get(i);
            Pair<ItemStack, ItemStack> pair = CommonUtils.getCompressingResult(stack, level);
            craftingResults.add(pair);
        }
        for (i = 0; i < this.slotCount(); ++i) {
            this.items.set(i, (Object)ItemStack.EMPTY);
            this.ghostItems.set(i, (Object)ItemStack.EMPTY);
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (Pair pair : craftingResults) {
            ItemStack stack1 = this.insertStackGeneral((ItemStack)pair.getFirst(), false);
            ItemStack stack2 = this.insertStackGeneral((ItemStack)pair.getSecond(), false);
            if (!stack1.isEmpty()) {
                leftovers.add(stack1);
            }
            if (stack2.isEmpty()) continue;
            leftovers.add(stack2);
        }
        for (ItemStack itemStack : leftovers) {
            if (itemStack.isEmpty() || player == null) continue;
            player.addItem(itemStack);
            if (itemStack.isEmpty()) continue;
            player.drop(itemStack, false);
        }
        this.sort();
    }

    void readItems(HolderLookup.Provider provider, ListTag listTag, List<ItemStack> list) {
        for (int i = 0; i < listTag.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = listTag.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (!this.inBounds(slot)) continue;
            if (itemTags.contains("StackList", 9)) {
                stack = ItemStack.EMPTY;
                ListTag stackTagList = itemTags.getList("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.getCompound(j);
                    ItemStack temp = SerializationHelper.decodeLargeItemStack(provider, itemTag);
                    if (temp.isEmpty()) continue;
                    if (stack.isEmpty()) {
                        stack = temp;
                        continue;
                    }
                    stack.grow(temp.getCount());
                }
                if (stack.isEmpty()) continue;
                int count = stack.getCount();
                count = Math.min(count, this.getMaxStackSizeDank());
                stack.setCount(count);
                list.set(slot, stack);
                continue;
            }
            stack = SerializationHelper.decodeLargeItemStack(provider, itemTags);
            list.set(slot, stack);
        }
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            ItemStack stack = (ItemStack)this.getContents().get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            nbtTagList.add((Object)SerializationHelper.encodeLargeStack(stack, provider, itemTag));
        }
        ListTag ghostItemNBT = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            ItemStack ghost = this.getGhostItem(i);
            if (ghost.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            ghostItemNBT.add((Object)ghost.save(provider, (Tag)itemTag));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.put(GHOST, (Tag)ghostItemNBT);
        nbt.putBoolean("locked", this.frequencyLocked());
        nbt.putString("SortingType", this.sortingType.name());
        nbt.putBoolean("AutoSort", this.autoSort);
        return nbt;
    }

    public void load(HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag tagList = nbt.getList("Items", 10);
        this.readItems(provider, tagList, (List<ItemStack>)this.items);
        ListTag ghostItemList = nbt.getList(GHOST, 10);
        this.readItems(provider, ghostItemList, (List<ItemStack>)this.ghostItems);
        if (nbt.contains("locked")) {
            this.frequencyLocked = nbt.getBoolean("locked");
        }
        try {
            if (nbt.contains("SortingType")) {
                this.sortingType = SortingType.valueOf(nbt.getString("SortingType"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nbt.contains("AutoSort")) {
            this.autoSort = nbt.getBoolean("AutoSort");
        }
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.slotCount(); ++slot) {
            ItemStack stack = this.getItemDank(slot);
            if (stack.isEmpty()) continue;
            f += (float)stack.getCount() / (float)this.getMaxStackSizeDank();
            ++numStacks;
        }
        return Mth.floor((float)((f /= (float)this.slotCount()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.slotCount()).mapToObj(this::getItemDank).allMatch(stack -> stack.isEmpty() || stack.is(ModTags.BLACKLISTED_USAGE));
    }

    public void upgradeTo(DankStats stats) {
        if (stats.slots > this.slotCount()) {
            this.setTo(stats);
        }
    }

    public void setTo(DankStats stats) {
        NonNullList newStacks = NonNullList.withSize((int)stats.slots, (Object)ItemStack.EMPTY);
        NonNullList newGhostStacks = NonNullList.withSize((int)stats.slots, (Object)ItemStack.EMPTY);
        int oldSlots = this.slotCount();
        int max = Math.min(oldSlots, stats.slots);
        for (int i = 0; i < max; ++i) {
            ItemStack oldStack = this.getItemDank(i);
            ItemStack oldGhost = this.getGhostItem(i);
            newStacks.set(i, (Object)oldStack);
            newGhostStacks.set(i, (Object)oldGhost);
        }
        this.setItemsDank((NonNullList<ItemStack>)newStacks);
        this.setGhostItems((NonNullList<ItemStack>)newGhostStacks);
        this.data.setStats(stats);
        this.capacity = stats.stacklimit;
    }

    public boolean hasGhostItem(int slot) {
        return !this.getGhostItem(slot).isEmpty();
    }

    public int getMaxStackSizeDank() {
        return this.capacity;
    }

    public void toggleGhostItem(int slot) {
        boolean loc = this.hasGhostItem(slot);
        if (loc) {
            this.setGhostItem(slot, ItemStack.EMPTY);
        } else {
            this.setGhostItem(slot, this.getItemDank(slot).copyWithCount(1));
        }
        this.setDirty(false);
    }

    public int slotCount() {
        return this.items.size();
    }

    public void setDirty(boolean needsSort) {
        if (this.data != null) {
            this.data.setDirty();
        }
        if (needsSort && this.autoSort) {
            this.sort();
        }
    }

    public List<ItemStack> getUniqueItems() {
        ArrayList<ItemStack> gathered = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            boolean matched = false;
            for (ItemStack itemStack : gathered) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
                itemStack.grow(stack.getCount());
                matched = true;
                break;
            }
            if (matched) continue;
            gathered.add(stack.copy());
        }
        return gathered;
    }

    public long countItem(ItemStack sel) {
        if (sel.isEmpty()) {
            return 0L;
        }
        long amount = this.items.stream().filter(stack -> ItemStack.isSameItemSameComponents((ItemStack)sel, (ItemStack)stack)).mapToLong(ItemStack::getCount).sum();
        return amount;
    }

    public boolean autoSort() {
        return this.autoSort;
    }

    public void toggleAutoSort() {
        this.autoSort = !this.autoSort;
        this.setDirty(false);
    }

    public void clear() {
        for (int i = 0; i < this.slotCount(); ++i) {
            this.items.set(i, (Object)ItemStack.EMPTY);
            this.ghostItems.set(i, (Object)ItemStack.EMPTY);
        }
    }
}

