/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.events;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.network.server.C2SScrollSlotPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.UseType;

public class ClientEvents {
    public static final Minecraft mc = Minecraft.getInstance();

    public static boolean onScroll(double delta) {
        LocalPlayer player = ClientEvents.mc.player;
        if (player != null) {
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            if (player.isCrouching() && (DankItem.isConstruction(main) || DankItem.isConstruction(off))) {
                boolean right = delta < 0.0;
                C2SScrollSlotPacket.send(right);
                return true;
            }
        }
        return false;
    }

    public static void renderSelectedItem(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        LocalPlayer player = ClientEvents.mc.player;
        if (player == null) {
            return;
        }
        if (!(player.containerMenu instanceof InventoryMenu)) {
            return;
        }
        ItemStack bag = player.getMainHandItem();
        if (!(bag.getItem() instanceof DankItem) && !((bag = player.getOffhandItem()).getItem() instanceof DankItem)) {
            return;
        }
        int xStart = guiGraphics.guiWidth() / 2 + ClientEvents.previewX();
        int yStart = guiGraphics.guiHeight() + ClientEvents.previewY();
        ItemStack toPlace = DankItem.getSelectedItem(bag);
        if (!toPlace.isEmpty() && ClientEvents.shouldPreview()) {
            Integer color = toPlace.getRarity().color().getColor();
            int c = color != null ? color : 0xFFFFFF;
            ClientEvents.renderHotbarItem(guiGraphics, xStart, yStart, toPlace);
        }
        UseType mode = DankItem.getUseType(bag);
        MutableComponent translate = mode.translate();
        int stringX = xStart + 8 - ClientEvents.mc.font.width((FormattedText)translate) / 2;
        int stringY = yStart + 16;
        guiGraphics.drawString(ClientEvents.mc.font, (Component)translate, stringX, stringY, 0xFFFFFF);
    }

    private static void renderHotbarItem(GuiGraphics poses, int x, int y, ItemStack stack) {
        poses.renderFakeItem(stack, x, y);
        poses.renderItemDecorations(ClientEvents.mc.font, stack, x, y);
    }

    private static boolean shouldPreview() {
        return Services.PLATFORM.getConfig().showPreview();
    }

    private static int previewX() {
        return Services.PLATFORM.getConfig().posX();
    }

    private static int previewY() {
        return Services.PLATFORM.getConfig().posY();
    }
}

