/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.TextComponents;
import tfar.dankstorage.client.DankKeybinds;
import tfar.dankstorage.client.DualTooltip;
import tfar.dankstorage.client.DynamicTooltip;
import tfar.dankstorage.client.NumberEditBox;
import tfar.dankstorage.client.StackSizeRenderer;
import tfar.dankstorage.client.button.SmallButton;
import tfar.dankstorage.client.screens.ConfigComponent;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.network.server.C2SLockSlotPacket;
import tfar.dankstorage.network.server.C2SSetFrequencyPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.TxtColor;

public class DankStorageScreen
extends AbstractContainerScreen<DankMenu> {
    static final ResourceLocation background1 = DankStorage.id("textures/container/gui/dank1.png");
    static final ResourceLocation background2 = DankStorage.id("textures/container/gui/dank2.png");
    static final ResourceLocation background3 = DankStorage.id("textures/container/gui/dank3.png");
    static final ResourceLocation background4 = DankStorage.id("textures/container/gui/dank4.png");
    static final ResourceLocation background5 = DankStorage.id("textures/container/gui/dank5.png");
    static final ResourceLocation background6 = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    static final ResourceLocation background7 = DankStorage.id("textures/container/gui/dank7.png");
    final ResourceLocation background;
    EditBox frequency;
    protected final boolean is7;
    Button changeSortingType;
    Button autoSort;
    private final ConfigComponent configComponent = new ConfigComponent();
    protected CycleButton<PickupMode> modeCycleButton;
    static final MutableComponent SAVE_C = DankStorageScreen.buildSaveComponent();
    static final MutableComponent PICKUP_C = DankStorageScreen.buildPickupComponent();
    static final MutableComponent STORAGE_TXT = CommonUtils.translatable("text.dankstorage.blacklisted_storage").withStyle(ChatFormatting.DARK_RED);
    static final MutableComponent USAGE_TXT = CommonUtils.translatable("text.dankstorage.blacklisted_usage").withStyle(ChatFormatting.DARK_RED);

    public DankStorageScreen(DankMenu $$0, Inventory $$1, Component $$2, ResourceLocation background) {
        super((AbstractContainerMenu)$$0, $$1, $$2);
        this.imageHeight = 114 + ((DankMenu)this.menu).rows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
        this.background = background;
        this.is7 = ((DankMenu)this.menu).rows > 6;
    }

    public static DankStorageScreen t1(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background1);
    }

    public static DankStorageScreen t2(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background2);
    }

    public static DankStorageScreen t3(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background3);
    }

    public static DankStorageScreen t4(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background4);
    }

    public static DankStorageScreen t5(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background5);
    }

    public static DankStorageScreen t6(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background6);
    }

    public static DankStorageScreen t7(DankMenu container, Inventory playerinventory, Component component) {
        return new DankStorageScreen(container, playerinventory, component, background7);
    }

    protected void initEditbox() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.frequency = new NumberEditBox(this.font, i + 92, j + this.inventoryLabelY, 56, 12, (Component)CommonUtils.translatable("dank"));
        this.frequency.setCanLoseFocus(true);
        this.frequency.setTextColor(-1);
        this.frequency.setTextColorUneditable(-1);
        this.frequency.setBordered(false);
        this.frequency.setMaxLength(10);
        this.frequency.setResponder(this::onNameChanged);
        this.frequency.setValue("");
        this.frequency.setTextColor(-16711936);
        this.addWidget((GuiEventListener)this.frequency);
    }

    private void onNameChanged(String string) {
        try {
            int i = Integer.parseInt(string);
            C2SSetFrequencyPacket.send(i, false);
        }
        catch (NumberFormatException e) {
            C2SSetFrequencyPacket.send(-1, false);
        }
    }

    public void renderSlot(GuiGraphics pGuiGraphics, Slot pSlot) {
        if (!((DankMenu)this.menu).isDankSlot(pSlot)) {
            super.renderSlot(pGuiGraphics, pSlot);
        } else {
            boolean locked;
            Pair pair;
            int i = pSlot.x;
            int j = pSlot.y;
            ItemStack itemstack = pSlot.getItem();
            boolean flag = false;
            boolean flag1 = pSlot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
            ItemStack itemstack1 = ((DankMenu)this.menu).getCarried();
            Object s = "";
            if (pSlot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !itemstack.isEmpty()) {
                itemstack = itemstack.copyWithCount(itemstack.getCount() / 2);
            } else if (this.isQuickCrafting && this.quickCraftSlots.contains(pSlot) && !itemstack1.isEmpty()) {
                if (this.quickCraftSlots.size() == 1) {
                    return;
                }
                if (AbstractContainerMenu.canItemQuickReplace((Slot)pSlot, (ItemStack)itemstack1, (boolean)true) && ((DankMenu)this.menu).canDragTo(pSlot)) {
                    flag = true;
                    int k = Math.min(itemstack1.getMaxStackSize(), pSlot.getMaxStackSize(itemstack1));
                    int l = pSlot.getItem().isEmpty() ? 0 : pSlot.getItem().getCount();
                    int i1 = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemstack1) + l;
                    if (i1 > k) {
                        i1 = k;
                        s = ChatFormatting.YELLOW.toString() + k;
                    }
                    itemstack = itemstack1.copyWithCount(i1);
                } else {
                    this.quickCraftSlots.remove(pSlot);
                    this.recalculateQuickCraftRemaining();
                }
            }
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            if (itemstack.isEmpty() && pSlot.isActive() && (pair = pSlot.getNoItemIcon()) != null) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                pGuiGraphics.blit(i, j, 0, 16, 16, textureatlassprite);
                flag1 = true;
            }
            boolean bl = locked = pSlot.index < ((DankMenu)this.menu).dankInventory.slotCount() && ((DankMenu)this.menu).dankInventory.hasGhostItem(pSlot.index);
            if (!flag1) {
                if (flag) {
                    pGuiGraphics.fill(i, j, i + 16, j + 16, -2130706433);
                }
                pGuiGraphics.renderItem(itemstack, i, j, pSlot.x + pSlot.y * this.imageWidth);
                pGuiGraphics.renderItemDecorations(this.font, itemstack, i, j, "");
                int count = itemstack.getCount();
                if (count > 1 || !((String)s).isEmpty() || locked) {
                    String string = (String)s + (count <= 0 && locked ? "lock" : CommonUtils.formatLargeNumber(itemstack.getCount()));
                    StackSizeRenderer.renderSizeLabelCustom(pGuiGraphics, Minecraft.getInstance().font, (float)i, (float)j, string, Services.PLATFORM.getConfig().textSize());
                }
            }
            pGuiGraphics.pose().popPose();
            int i1 = pSlot.x;
            int j1 = pSlot.y;
            if (!pSlot.hasItem() && locked) {
                pGuiGraphics.renderFakeItem(((DankMenu)this.menu).dankInventory.getGhostItem(pSlot.index), i1, j1);
                RenderSystem.depthFunc((int)516);
                pGuiGraphics.fill(i1, j1, i1 + 16, j1 + 16, 0x40FFFFFF);
                RenderSystem.depthFunc((int)515);
            }
        }
    }

    private void sendButtonToServer(DankMenu.ButtonAction action) {
        this.minecraft.gameMode.handleInventoryButtonClick(((DankMenu)this.menu).containerId, action.ordinal());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int color = ((DankMenu)this.menu).dankInventory.getTextColor();
        this.frequency.setTextColor(color);
        PickupMode pickupMode = ((DankMenu)this.menu).getMode();
        this.modeCycleButton.setValue((Object)pickupMode);
        this.frequency.render(graphics, mouseX, mouseY, partialTicks);
        this.configComponent.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics poseStack, int i, int j) {
        RenderSystem.disableBlend();
        super.renderLabels(poseStack, i, j);
        int id = DankItem.getFrequency(((DankMenu)this.menu).getBag());
        int color = 32768;
        poseStack.drawString(this.font, "ID: " + id, 62, this.inventoryLabelY, color, false);
    }

    public void appendDankInfo(List<Component> tooltip, ItemStack stack) {
        if (stack.is(ModTags.BLACKLISTED_STORAGE)) {
            tooltip.add((Component)STORAGE_TXT);
        }
        if (stack.is(ModTags.BLACKLISTED_USAGE)) {
            tooltip.add((Component)USAGE_TXT);
        }
        if (((DankMenu)this.menu).isDankSlot(this.hoveredSlot)) {
            MutableComponent component1 = CommonUtils.translatable("text.dankstorage.lock", DankKeybinds.LOCK_SLOT.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)component1);
            if (stack.getCount() >= 1000) {
                MutableComponent component2 = CommonUtils.translatable("text.dankstorage.exact", CommonUtils.literal(Integer.toString(stack.getCount())).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY);
                tooltip.add((Component)component2);
            }
        }
    }

    protected void init() {
        super.init();
        this.configComponent.init(this.width, this.height, this.minecraft, (DankMenu)this.menu);
        int j = (this.height - this.imageHeight) / 2;
        DynamicTooltip dynamicTooltip = DynamicTooltip.dynamic(() -> Component.translatable((String)("dankstorage.sorting_type." + String.valueOf((Object)((DankMenu)this.menu).dankInventory.getSortingType()))));
        SmallButton sort = new SmallButton(this.leftPos + 143 - 16, this.topPos + 4, 26, 12, (Component)Component.literal((String)"Sort"), b -> {
            this.sendButtonToServer(DankMenu.ButtonAction.SORT);
            dynamicTooltip.dirty = true;
        });
        sort.setTooltip(dynamicTooltip);
        this.addRenderableWidget((GuiEventListener)sort);
        this.modeCycleButton = CycleButton.builder(pickupMode -> Component.literal((String)"P").withStyle(Style.EMPTY.withColor(DankItem.getPickupMode(((DankMenu)this.menu).getBag()).getColor()))).withValues((Object[])PickupMode.VALUES).withTooltip(mode -> Tooltip.create((Component)DankItem.getPickupMode(((DankMenu)this.menu).getBag()).translate())).withInitialValue((Object)DankItem.getPickupMode(((DankMenu)this.menu).getBag())).displayOnlyValue().create(this.leftPos + 101 - 16, this.topPos + 4, 12, 12, (Component)Component.empty(), (pickupModeCycleButton, pickupMode) -> this.sendButtonToServer(DankMenu.ButtonAction.TOGGLE_PICKUP));
        this.addRenderableWidget((GuiEventListener)this.modeCycleButton);
        DualTooltip freqTooltip = new DualTooltip((Component)Component.translatable((String)"text.dankstorage.unlock_button"), (Component)Component.translatable((String)"text.dankstorage.lock_button"), null, this);
        SmallButton lock = new SmallButton(this.leftPos + 115 - 16, this.topPos + 4, 12, 12, (Component)Component.literal((String)""), button -> this.sendButtonToServer(DankMenu.ButtonAction.LOCK_FREQUENCY)){

            public Component getMessage() {
                return ((DankMenu)((DankStorageScreen)DankStorageScreen.this).menu).dankInventory.frequencyLocked() ? Component.literal((String)"X").withStyle(ChatFormatting.RED) : Component.literal((String)"O");
            }
        };
        lock.setTooltip(freqTooltip);
        this.addRenderableWidget((GuiEventListener)lock);
        Tooltip saveTooltip = Tooltip.create((Component)SAVE_C);
        SmallButton s = new SmallButton(this.leftPos + 155, j + this.inventoryLabelY - 2, 12, 12, (Component)Component.literal((String)"s"), b -> {
            try {
                if (((DankMenu)this.menu).dankInventory.frequencyLocked()) {
                    return;
                }
                int id1 = Integer.parseInt(this.frequency.getValue());
                C2SSetFrequencyPacket.send(id1, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        s.setTooltip(saveTooltip);
        this.addRenderableWidget((GuiEventListener)s);
        Tooltip compressTooltip = Tooltip.create((Component)Component.translatable((String)"text.dankstorage.compress_button"));
        SmallButton c = new SmallButton(this.leftPos + 129 - 16, this.topPos + 4, 12, 12, (Component)Component.literal((String)"C"), button -> this.sendButtonToServer(DankMenu.ButtonAction.COMPRESS));
        c.setTooltip(compressTooltip);
        this.addRenderableWidget((GuiEventListener)c);
        Tooltip tooltip = Tooltip.create((Component)TextComponents.OPEN_CONFIG);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd27"), b -> this.toggleConfig()).pos(this.leftPos + 157, this.topPos + 4).size(12, 12).tooltip(tooltip).build());
        DynamicTooltip dynamicTooltipSorting = DynamicTooltip.dynamic(() -> Component.translatable((String)("dankstorage.sorting_type." + String.valueOf((Object)((DankMenu)this.menu).dankInventory.getSortingType()) + ".desc")));
        this.changeSortingType = new Button(this.leftPos - 89, this.topPos + 24, 90, 16, (Component)Component.empty(), b -> {
            this.sendButtonToServer(DankMenu.ButtonAction.CYCLE_SORT_TYPE);
            dynamicTooltipSorting.dirty = true;
        }, Supplier::get){

            public Component getMessage() {
                return Component.translatable((String)("dankstorage.sorting_type." + String.valueOf((Object)((DankMenu)((DankStorageScreen)DankStorageScreen.this).menu).dankInventory.getSortingType())));
            }
        };
        this.changeSortingType.setTooltip((Tooltip)dynamicTooltipSorting);
        this.addRenderableWidget((GuiEventListener)this.changeSortingType);
        this.autoSort = new Button(this.leftPos - 89, this.topPos + 44, 90, 16, (Component)Component.empty(), b -> this.sendButtonToServer(DankMenu.ButtonAction.TOGGLE_AUTO_SORT), Supplier::get){

            public Component getMessage() {
                return Component.translatable((String)"dankstorage.auto_sort").append(" ").append(((DankMenu)((DankStorageScreen)DankStorageScreen.this).menu).dankInventory.autoSort() ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.autoSort);
        if (!this.configComponent.isVisible()) {
            this.changeSortingType.visible = false;
            this.autoSort.visible = false;
        }
        this.initEditbox();
    }

    void toggleConfig() {
        this.configComponent.toggleVisibility();
        this.changeSortingType.visible = this.configComponent.isVisible();
        this.autoSort.visible = this.configComponent.isVisible();
    }

    public List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        List tooltipFromItem = super.getTooltipFromContainerItem(itemStack);
        this.appendDankInfo(tooltipFromItem, itemStack);
        return tooltipFromItem;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (this.is7) {
            guiGraphics.blit(this.background, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 512);
        } else {
            guiGraphics.blit(this.background, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        }
        this.renderLockedSlots(guiGraphics);
        this.configComponent.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
    }

    protected void renderLockedSlots(GuiGraphics guiGraphics) {
        for (int i = 0; i < ((DankMenu)this.menu).rows * 9; ++i) {
            int j = i % 9;
            int k = i / 9;
            int offsetx = 8;
            int offsety = 18;
            if (!((DankMenu)this.menu).dankInventory.hasGhostItem(i)) continue;
            guiGraphics.fill(this.leftPos + j * 18 + offsetx, this.topPos + k * 18 + offsety, this.leftPos + j * 18 + offsetx + 16, this.topPos + k * 18 + offsety + 16, -65536);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean match;
        if (keyCode == 256 || Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.minecraft.player.closeContainer();
        }
        if ((match = DankKeybinds.LOCK_SLOT.matches(keyCode, scanCode)) && this.hoveredSlot != null && ((DankMenu)this.menu).isDankSlot(this.hoveredSlot)) {
            C2SLockSlotPacket.send(this.hoveredSlot.index);
            return true;
        }
        if (!match && (this.frequency.keyPressed(keyCode, scanCode, modifiers) || this.frequency.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static MutableComponent buildSaveComponent() {
        return CommonUtils.translatable("text.dankstorage.save_frequency_button", CommonUtils.translatable("text.dankstorage.save_frequency_button.invalid", CommonUtils.translatable("text.dankstorage.save_frequency_button.invalidtxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(TxtColor.INVALID.color)), CommonUtils.translatable("text.dankstorage.save_frequency_button.too_high", CommonUtils.translatable("text.dankstorage.save_frequency_button.too_hightxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(TxtColor.TOO_HIGH.color)), CommonUtils.translatable("text.dankstorage.save_frequency_button.different_tier", CommonUtils.translatable("text.dankstorage.save_frequency_button.different_tiertxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(TxtColor.DIFFERENT_TIER.color)), CommonUtils.translatable("text.dankstorage.save_frequency_button.good", CommonUtils.translatable("text.dankstorage.save_frequency_button.goodtxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(TxtColor.GOOD.color)), CommonUtils.translatable("text.dankstorage.save_frequency_button.locked_frequency", CommonUtils.translatable("text.dankstorage.save_frequency_button.locked_frequencytxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(TxtColor.LOCKED.color)));
    }

    private static MutableComponent buildPickupComponent() {
        return CommonUtils.translatable("text.dankstorage.pickup_button", CommonUtils.translatable("text.dankstorage.pickup_button.none", CommonUtils.translatable("text.dankstorage.pickup_button.nonetxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(PickupMode.none.getColor())), CommonUtils.translatable("text.dankstorage.pickup_button.all", CommonUtils.translatable("text.dankstorage.pickup_button.alltxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(PickupMode.pickup_all.getColor())), CommonUtils.translatable("text.dankstorage.pickup_button.filtered", CommonUtils.translatable("text.dankstorage.pickup_button.filteredtxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(PickupMode.filtered_pickup.getColor())), CommonUtils.translatable("text.dankstorage.pickup_button.void", CommonUtils.translatable("text.dankstorage.pickup_button.voidtxt").withStyle(ChatFormatting.GRAY)).withStyle(Style.EMPTY.withColor(PickupMode.void_pickup.getColor())));
    }
}

