/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client.screens;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tfar.dankstorage.client.DualTooltip2;
import tfar.dankstorage.client.NumberEditBox;
import tfar.dankstorage.client.button.SmallButton;
import tfar.dankstorage.client.screens.DankStorageScreen;
import tfar.dankstorage.menu.ChangeFrequencyMenu;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.network.server.C2SSetFrequencyPacket;
import tfar.dankstorage.utils.CommonUtils;

public class ChangeFrequencyScreen
extends AbstractContainerScreen<ChangeFrequencyMenu> {
    public static final ResourceLocation DEMO_BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/demo_background.png");
    EditBox frequency;

    public ChangeFrequencyScreen(ChangeFrequencyMenu $$0, Inventory $$1, Component $$2) {
        super((AbstractContainerMenu)$$0, $$1, $$2);
        this.imageWidth = 236;
    }

    protected void initEditbox() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.frequency = new NumberEditBox(this.font, i + 84, j + this.inventoryLabelY, 64, 12, (Component)CommonUtils.translatable("dank"));
        this.frequency.setCanLoseFocus(true);
        this.frequency.setTextColor(-1);
        this.frequency.setTextColorUneditable(-1);
        this.frequency.setMaxLength(10);
        this.frequency.setResponder(this::onNameChanged);
        this.frequency.setValue("");
        this.frequency.setTextColor(-16711936);
        this.addWidget((GuiEventListener)this.frequency);
    }

    protected void init() {
        super.init();
        int j = (this.height - this.imageHeight) / 2;
        SmallButton l = new SmallButton(this.leftPos + 170, j + this.inventoryLabelY, 12, 12, (Component)Component.literal((String)""), button -> this.sendButtonToServer(DankMenu.ButtonAction.LOCK_FREQUENCY)){

            public Component getMessage() {
                return ((ChangeFrequencyMenu)ChangeFrequencyScreen.this.menu).getFreqLock() ? Component.literal((String)"X").withStyle(ChatFormatting.RED) : Component.literal((String)"O");
            }
        };
        DualTooltip2 freqTooltip = new DualTooltip2((Component)Component.translatable((String)"text.dankstorage.unlock_button"), (Component)Component.translatable((String)"text.dankstorage.lock_button"), null, this);
        l.setTooltip(freqTooltip);
        this.addRenderableWidget((GuiEventListener)l);
        Tooltip saveTooltip = Tooltip.create((Component)DankStorageScreen.SAVE_C);
        SmallButton s = new SmallButton(this.leftPos + 155, j + this.inventoryLabelY, 12, 12, (Component)Component.literal((String)"s"), b -> {
            try {
                int id1 = Integer.parseInt(this.frequency.getValue());
                C2SSetFrequencyPacket.send(id1, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        s.setTooltip(saveTooltip);
        this.addRenderableWidget((GuiEventListener)s);
        this.initEditbox();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int color = ((ChangeFrequencyMenu)this.menu).getTextColor();
        this.frequency.setTextColor(color);
        this.frequency.render(graphics, mouseX, mouseY, partialTicks);
    }

    private void onNameChanged(String string) {
        try {
            int i = Integer.parseInt(string);
            C2SSetFrequencyPacket.send(i, false);
        }
        catch (NumberFormatException e) {
            C2SSetFrequencyPacket.send(-1, false);
        }
    }

    private void sendButtonToServer(DankMenu.ButtonAction action) {
        this.minecraft.gameMode.handleInventoryButtonClick(((ChangeFrequencyMenu)this.menu).containerId, action.ordinal());
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        int id = ((ChangeFrequencyMenu)this.menu).getFrequency();
        int color = 32768;
        int txtWidth = this.font.width("ID: " + id);
        graphics.drawString(this.font, "ID: " + id, 62 - txtWidth, this.inventoryLabelY + 1, color, false);
        MutableComponent warning = Component.translatable((String)"text.dankstorage.tier_mismatch");
        graphics.drawWordWrap(this.font, (FormattedText)warning, 5, this.inventoryLabelY + 18, 260, 0x404040);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.minecraft.player.closeContainer();
        }
        if (this.frequency.keyPressed(keyCode, scanCode, modifiers) || this.frequency.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int $$1 = (this.width - 248) / 2;
        int $$2 = (this.height - 166) / 2;
        guiGraphics.blit(DEMO_BACKGROUND_LOCATION, $$1, $$2, 0, 0, 248, 166);
    }
}

