/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.init.ModBlockEntityTypes;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.world.DankSavedData;

public class DockBlockEntity
extends BlockEntity
implements Nameable,
MenuProvider {
    ItemStack dank = ItemStack.EMPTY;
    public int numPlayersUsing = 0;
    public static final DankInventory EMPTY = Services.PLATFORM.createInventory(DankStats.zero, null);

    public DockBlockEntity(BlockPos $$1, BlockState $$2) {
        super(ModBlockEntityTypes.dock, $$1, $$2);
    }

    public ItemStack getDank() {
        return this.dank;
    }

    public void setFrequency(int freq) {
        if (!this.dank.isEmpty()) {
            DankItem.setFrequency(this.dank, freq);
        }
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.setChanged();
            return true;
        }
        return super.triggerEvent(id, type);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        Item item = this.dank.getItem();
        if (item instanceof DankItem) {
            DankItem tankItem = (DankItem)item;
            return tankItem.createProvider(this.dank).createMenu(i, inventory, player);
        }
        return null;
    }

    public DankInventory getInventory() {
        if (!(this.dank.getItem() instanceof DankItem)) {
            return EMPTY;
        }
        int frequency = DankItem.getFrequency(this.dank);
        if (frequency < 0) {
            return EMPTY;
        }
        return DankSavedData.get(DankItem.getFrequency(this.dank), this.level.getServer()).getOrCreateInventory();
    }

    public Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    public Component getName() {
        Component custom = this.getCustomName();
        return custom != null ? custom : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.dank.isEmpty() ? null : this.dank.getHoverName();
    }

    public int getComparatorSignal() {
        return this.getInventory().calcRedstone();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.dank = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("dank"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("dank", this.dank.saveOptional(pRegistries));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void giveToPlayer(Player player) {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        if (!player.addItem(dankInStack)) {
            ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), dankInStack);
            this.level.addFreshEntity((Entity)entity);
        }
    }

    public void removeDankWithItemSpawn() {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), dankInStack);
        this.level.addFreshEntity((Entity)entity);
    }

    public ItemStack removeDankWithoutItemSpawn() {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DockBlock.TIER, (Comparable)Integer.valueOf(0)));
        ItemStack stack = this.dank.copy();
        this.dank = ItemStack.EMPTY;
        this.setChanged();
        return stack;
    }

    public void addDank(ItemStack tank) {
        Item item = tank.getItem();
        if (item instanceof DankItem) {
            DankItem tankItem = (DankItem)item;
            DankStats stats = tankItem.stats;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
            this.dank = tank.split(1);
            this.setChanged();
        }
    }

    public void upgradeTo(DankStats stats) {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
        DankInventory dankInventory = this.getInventory();
        dankInventory.upgradeTo(stats);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        if (!this.dank.isEmpty()) {
            DataComponentMap components = this.dank.getComponents();
            for (DataComponentType type : components.keySet()) {
                pComponents.set(type, this.dank.get(type));
            }
        }
    }
}

