/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.blockentity.DockBlockEntity;

public class DankDispenserBehavior
implements DispenseItemBehavior {
    public ItemStack dispense(BlockSource pointer, ItemStack stack) {
        BlockPos blockPos;
        ServerLevel world = pointer.level();
        BlockState state = world.getBlockState(blockPos = pointer.pos().relative((Direction)pointer.state().getValue((Property)DispenserBlock.FACING)));
        if (state.getBlock() instanceof DockBlock && (Integer)state.getValue((Property)DockBlock.TIER) == 0) {
            this.insertDank(world, blockPos, stack);
            return ItemStack.EMPTY;
        }
        if (state.getBlock() instanceof DockBlock) {
            ItemStack old = this.removeDank(world, blockPos);
            this.insertDank(world, blockPos, stack);
            return old;
        }
        return stack;
    }

    public ItemStack removeDank(ServerLevel world, BlockPos pos) {
        DockBlockEntity dockBlockEntity = (DockBlockEntity)world.getBlockEntity(pos);
        return dockBlockEntity.removeDankWithoutItemSpawn();
    }

    public void insertDank(ServerLevel world, BlockPos pos, ItemStack stack) {
        DockBlockEntity dockBlockEntity = (DockBlockEntity)world.getBlockEntity(pos);
        dockBlockEntity.addDank(stack);
    }
}

