/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.recipe.HarvestingRecipeInput;

public class HarvestingRecipe
implements Recipe<HarvestingRecipeInput> {
    private final Block input;
    private final ItemStack output;
    private final IntegerProperty ageProperty;

    public HarvestingRecipe(Block input, ItemStack output) {
        Preconditions.checkNotNull((Object)input, (Object)"block cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Optional<IntegerProperty> property = input.defaultBlockState().getValues().keySet().stream().filter(key -> {
            IntegerProperty ip;
            return key instanceof IntegerProperty && (ip = (IntegerProperty)key).getName().equals("age");
        }).map(IntegerProperty.class::cast).findFirst();
        Preconditions.checkState((boolean)property.isPresent(), (Object)"block must have an age property.");
        Preconditions.checkState((!output.isEmpty() ? 1 : 0) != 0, (Object)"output cannot be empty.");
        this.input = input;
        this.output = output;
        this.ageProperty = property.get();
    }

    public RecipeType<?> getType() {
        return ModRegistry.HARVESTING_RECIPE_TYPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRegistry.HARVESTING_RECIPE_SERIALIZER.get();
    }

    public Block getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    public int getMaxAge() {
        return this.ageProperty.max;
    }

    public int getMinAge() {
        return this.ageProperty.min;
    }

    public boolean matches(HarvestingRecipeInput input, Level level) {
        return this.input.equals(input.block());
    }

    public ItemStack assemble(HarvestingRecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public static class Serializer
    implements RecipeSerializer<HarvestingRecipe> {
        private static final Codec<Block> BLOCK_CODEC = BuiltInRegistries.BLOCK.byNameCodec();
        private static final MapCodec<HarvestingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BLOCK_CODEC.fieldOf("block").forGetter(HarvestingRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(HarvestingRecipe::getOutput)).apply((Applicative)instance, HarvestingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, Block> BLOCK_STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.BLOCK);
        private static final StreamCodec<RegistryFriendlyByteBuf, HarvestingRecipe> STREAM_CODEC = StreamCodec.composite(BLOCK_STREAM_CODEC, HarvestingRecipe::getInput, (StreamCodec)ItemStack.STREAM_CODEC, HarvestingRecipe::getOutput, HarvestingRecipe::new);

        public MapCodec<HarvestingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HarvestingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

