/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.protection;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.BlockComponent;
import net.permutated.pylons.components.EntityComponent;
import net.permutated.pylons.item.BlockFilterCard;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.ProtectionManager;

public class ProtectionPylonTile
extends AbstractPylonTile {
    private boolean dirty = true;

    public ProtectionPylonTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PROTECTION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{1, 3, 5};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.getItem() instanceof MobFilterCard || stack.getItem() instanceof BlockFilterCard;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(20) && this.dirty) {
                HashSet<ProtectionManager.Filter> filters = new HashSet<ProtectionManager.Filter>();
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    Record data;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (!stack.isEmpty() && stack.getItem() instanceof MobFilterCard) {
                        data = (EntityComponent)stack.get(ModRegistry.ENTITY_COMPONENT);
                        if (data == null) continue;
                        filters.add(ProtectionManager.mobFilter(this.owner, ((EntityComponent)data).registryKey()));
                        continue;
                    }
                    if (stack.isEmpty() || !(stack.getItem() instanceof BlockFilterCard) || (data = (BlockComponent)stack.get(ModRegistry.BLOCK_COMPONENT)) == null) continue;
                    filters.add(ProtectionManager.blockFilter(this.owner, ((BlockComponent)data).registryKey()));
                }
                ProtectionManager.register(serverLevel, this.worldPosition, this.range, filters);
                this.dirty = false;
            }
        }
    }

    @Override
    public boolean shouldWork() {
        if (super.shouldWork()) {
            return true;
        }
        this.removeChunkloads();
        return false;
    }

    @Override
    public void removeChunkloads() {
        super.removeChunkloads();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ProtectionManager.unregister(serverLevel, this.worldPosition);
            this.dirty = true;
        }
    }

    public void setChanged() {
        super.setChanged();
        this.dirty = true;
    }
}

