/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.trades.BiomeWoodToItemListing;
import net.mehvahdjukaar.sawmill.trades.LogStrippingListing;
import net.mehvahdjukaar.sawmill.trades.RandomWoodToItemListing;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerType;

public final class CarpenterTrades {
    private static final Supplier<Map<VillagerType, List<WoodType>>> TYPE_MAP = Suppliers.memoize(() -> {
        HashMap<VillagerType, List<WoodType>> map = new HashMap<VillagerType, List<WoodType>>();
        map.put(VillagerType.PLAINS, List.of(CarpenterTrades.wood("birch"), CarpenterTrades.wood("oak")));
        map.put(VillagerType.JUNGLE, List.of(CarpenterTrades.wood("jungle"), CarpenterTrades.wood("bamboo")));
        map.put(VillagerType.SNOW, List.of(CarpenterTrades.wood("spruce")));
        map.put(VillagerType.TAIGA, List.of(CarpenterTrades.wood("spruce")));
        map.put(VillagerType.SAVANNA, List.of(CarpenterTrades.wood("acacia")));
        ArrayList<WoodType> desertList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(desertList, "cactus");
        if (desertList.isEmpty()) {
            desertList.add(CarpenterTrades.wood("jungle"));
        }
        map.put(VillagerType.DESERT, desertList);
        ArrayList<WoodType> swampList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(swampList, "swamp", "cypress");
        if (swampList.isEmpty()) {
            swampList.add(CarpenterTrades.wood("dark_oak"));
        }
        map.put(VillagerType.SWAMP, swampList);
        return map;
    });

    public static void init() {
        ItemListingManager.registerSerializer((ResourceLocation)SawmillMod.res("random_wood_item_to_emerald"), RandomWoodToItemListing.CODEC);
        ItemListingManager.registerSerializer((ResourceLocation)SawmillMod.res("wood_item_to_emerald"), BiomeWoodToItemListing.CODEC);
        ItemListingManager.registerSerializer((ResourceLocation)SawmillMod.res("log_stripping"), LogStrippingListing.CODEC);
    }

    private static WoodType wood(String name) {
        return (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)name));
    }

    private static void maybeAddWood(List<WoodType> list, String ... names) {
        for (WoodType t : WoodTypeRegistry.INSTANCE) {
            for (String name : names) {
                if (!t.id.getPath().contains(name)) continue;
                list.add(t);
            }
        }
    }
}

