/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.placement;

import com.blackgear.platform.common.worldgen.placement.Placement;
import com.blackgear.platform.common.worldgen.placement.parameters.Depth;
import com.blackgear.platform.common.worldgen.placement.parameters.Weirdness;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class BiomePlacement {
    public static final List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> BIOME_PLACEMENTS = Lists.newArrayList();

    public static void registerBiomePlacements(Consumer<Event> listener) {
        listener.accept(BIOME_PLACEMENTS::add);
    }

    public static interface Event {
        public void add(Pair<Climate.ParameterPoint, ResourceKey<Biome>> var1);

        default public void addBiome(Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter depth, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
            this.add((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (float)Climate.quantizeCoord((float)offset)), biome));
        }

        default public void addSurfaceBiome(Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
            this.addBiome(temperature, humidity, continentalness, erosion, Depth.SURFACE.parameter(), weirdness, offset, biome);
            this.addBiome(temperature, humidity, continentalness, erosion, Depth.FLOOR.parameter(), weirdness, offset, biome);
        }

        default public void addUndergroundBiome(Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
            this.addBiome(temperature, humidity, continentalness, erosion, Depth.UNDERGROUND.parameter(), weirdness, offset, biome);
        }

        default public void addBottomBiome(Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
            this.addBiome(temperature, humidity, continentalness, erosion, Depth.FLOOR.parameter(), weirdness, offset, biome);
        }

        default public void addSurfaceBiome(Placement placement, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, float offset, ResourceKey<Biome> biome) {
            for (Weirdness weirdness : placement.getWeirdnesses()) {
                this.addSurfaceBiome(temperature, humidity, continentalness, erosion, weirdness.parameter(), offset, biome);
            }
        }
    }
}

