/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.data.neoforge;

import com.blackgear.platform.Platform;
import com.blackgear.platform.common.data.LootModifier;
import com.blackgear.platform.common.data.neoforge.LootPoolAccess;
import com.blackgear.platform.core.mixin.neoforge.access.LootTableAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="platform")
public class LootModifierImpl {
    private static final Set<Consumer<LootTableLoadEvent>> MODIFICATIONS = ConcurrentHashMap.newKeySet();

    public static void modify(LootModifier.LootTableModifier modifier) {
        MODIFICATIONS.add(event -> modifier.modify((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)event.getName()), new LootModifier.LootTableContext((LootTableLoadEvent)event){
            final /* synthetic */ LootTableLoadEvent val$event;
            {
                this.val$event = lootTableLoadEvent;
            }

            @Override
            public void addPool(LootPool.Builder pool) {
                ((LootTableAccessor)this.val$event.getTable()).getPools().add(pool.build());
            }

            @Override
            public boolean addToPool(int index, ArrayList<LootPoolEntryContainer> content) {
                LootTable table = this.val$event.getTable();
                try {
                    List<LootPool> pools = ((LootTableAccessor)table).getPools();
                    if (pools.size() > index) {
                        LootPool pool = pools.get(index);
                        List<LootPoolEntryContainer> entries = ((LootPoolAccess)pool).getEntries();
                        ArrayList<LootPoolEntryContainer> modified = new ArrayList<LootPoolEntryContainer>(entries);
                        modified.addAll(content);
                        ((LootPoolAccess)pool).setEntries(modified);
                        return true;
                    }
                }
                catch (Throwable t) {
                    Platform.LOGGER.error("Failed to add content to loot pool at index {}: {}", (Object)index, (Object)t.getMessage(), (Object)t);
                }
                return false;
            }
        }, true));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLootTableModify(LootTableLoadEvent event) {
        MODIFICATIONS.forEach(consumer -> consumer.accept(event));
    }
}

