/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Hashtable;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.IteratorLikeIterable;
import dev.latvian.mods.rhino.NativeCollectionIterator;
import dev.latvian.mods.rhino.NativeSet;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Undefined;

public class NativeMap
extends IdScriptableObject {
    static final String ITERATOR_TAG = "Map Iterator";
    private static final Object MAP_TAG = "Map";
    private static final Object NULL_VALUE = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_set = 2;
    private static final int Id_get = 3;
    private static final int Id_delete = 4;
    private static final int Id_has = 5;
    private static final int Id_clear = 6;
    private static final int Id_keys = 7;
    private static final int Id_values = 8;
    private static final int Id_entries = 9;
    private static final int Id_forEach = 10;
    private static final int SymbolId_getSize = 11;
    private static final int SymbolId_toStringTag = 12;
    private static final int MAX_PROTOTYPE_ID = 12;
    private final Hashtable entries;
    private boolean instanceOfMap = false;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeMap obj = new NativeMap(cx);
        obj.exportAsJSClass(12, scope, false, cx);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put(cx, "enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put(cx, "configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        desc.put(cx, "get", (Scriptable)desc, obj.get(cx, NativeSet.GETSIZE, (Scriptable)obj));
        obj.defineOwnProperty(cx, "size", desc);
        if (sealed) {
            obj.sealObject(cx);
        }
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject map, Object arg1) {
        if (arg1 == null || Undefined.INSTANCE.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(cx, scope, arg1);
        if (Undefined.INSTANCE.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeMap.ensureScriptableObject(cx.newObject(scope, map.getClassName()), cx);
        Callable set = ScriptRuntime.getPropFunctionAndThis(cx, scope, dummy.getPrototype(cx), "set");
        cx.lastStoredScriptable();
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal;
                Scriptable sVal = NativeMap.ensureScriptable(val, cx);
                if (sVal instanceof Symbol) {
                    throw ScriptRuntime.typeError1(cx, "msg.arg.not.object", (Object)ScriptRuntime.typeof(cx, sVal));
                }
                Object finalKey = sVal.get(cx, 0, sVal);
                if (finalKey == NOT_FOUND) {
                    finalKey = Undefined.INSTANCE;
                }
                if ((finalVal = sVal.get(cx, 1, sVal)) == NOT_FOUND) {
                    finalVal = Undefined.INSTANCE;
                }
                set.call(cx, scope, map, new Object[]{finalKey, finalVal});
            }
        }
    }

    private static NativeMap realThis(Scriptable thisObj, IdFunctionObject f, Context cx) {
        if (thisObj == null) {
            throw NativeMap.incompatibleCallError(f, cx);
        }
        try {
            NativeMap nm = (NativeMap)thisObj;
            if (!nm.instanceOfMap) {
                throw NativeMap.incompatibleCallError(f, cx);
            }
            return nm;
        }
        catch (ClassCastException cce) {
            throw NativeMap.incompatibleCallError(f, cx);
        }
    }

    public NativeMap(Context cx) {
        this.entries = new Hashtable(cx);
    }

    @Override
    public String getClassName() {
        return "Map";
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(MAP_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj == null) {
                    NativeMap nm = new NativeMap(cx);
                    nm.instanceOfMap = true;
                    if (args.length > 0) {
                        NativeMap.loadFromIterable(cx, scope, nm, args[0]);
                    }
                    return nm;
                }
                throw ScriptRuntime.typeError1(cx, "msg.no.new", "Map");
            }
            case 2: {
                return NativeMap.realThis(thisObj, f, cx).js_set(cx, args.length > 0 ? args[0] : Undefined.INSTANCE, args.length > 1 ? args[1] : Undefined.INSTANCE);
            }
            case 4: {
                return NativeMap.realThis(thisObj, f, cx).js_delete(cx, args.length > 0 ? args[0] : Undefined.INSTANCE);
            }
            case 3: {
                return NativeMap.realThis(thisObj, f, cx).js_get(cx, args.length > 0 ? args[0] : Undefined.INSTANCE);
            }
            case 5: {
                return NativeMap.realThis(thisObj, f, cx).js_has(cx, args.length > 0 ? args[0] : Undefined.INSTANCE);
            }
            case 6: {
                return NativeMap.realThis(thisObj, f, cx).js_clear(cx);
            }
            case 7: {
                return NativeMap.realThis(thisObj, f, cx).js_iterator(scope, NativeCollectionIterator.Type.KEYS, cx);
            }
            case 8: {
                return NativeMap.realThis(thisObj, f, cx).js_iterator(scope, NativeCollectionIterator.Type.VALUES, cx);
            }
            case 9: {
                return NativeMap.realThis(thisObj, f, cx).js_iterator(scope, NativeCollectionIterator.Type.BOTH, cx);
            }
            case 10: {
                return NativeMap.realThis(thisObj, f, cx).js_forEach(cx, scope, args.length > 0 ? args[0] : Undefined.INSTANCE, args.length > 1 ? args[1] : Undefined.INSTANCE);
            }
            case 11: {
                return NativeMap.realThis(thisObj, f, cx).js_getSize();
            }
        }
        throw new IllegalArgumentException("Map.prototype has no method: " + f.getFunctionName());
    }

    private Object js_set(Context cx, Object k, Object v) {
        Object value = v == null ? NULL_VALUE : v;
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = ScriptRuntime.zeroObj;
        }
        this.entries.put(cx, key, value);
        return this;
    }

    private Object js_delete(Context cx, Object arg) {
        Object e = this.entries.delete(cx, arg);
        return e != null;
    }

    private Object js_get(Context cx, Object arg) {
        Object val = this.entries.get(cx, arg);
        if (val == null) {
            return Undefined.INSTANCE;
        }
        if (val == NULL_VALUE) {
            return null;
        }
        return val;
    }

    private Object js_has(Context cx, Object arg) {
        return this.entries.has(cx, arg);
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type, Context cx) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator(), cx);
    }

    private Object js_clear(Context cx) {
        this.entries.clear(cx);
        return Undefined.INSTANCE;
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeError2(cx, "msg.isnt.function", arg1, (Object)ScriptRuntime.typeof(cx, arg1));
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Object val;
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_INSTANCE;
            }
            if ((val = entry.value) == NULL_VALUE) {
                val = null;
            }
            f.call(cx, scope, thisObj, new Object[]{val, entry.key, this});
        }
        return Undefined.INSTANCE;
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        switch (id) {
            case 11: {
                this.initPrototypeMethod(MAP_TAG, id, NativeSet.GETSIZE, "get size", 0, cx);
                return;
            }
            case 12: {
                this.initPrototypeValue(12, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String fnName = null;
        this.initPrototypeMethod(MAP_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "constructor";
            }
            case 2 -> {
                arity = 2;
                yield "set";
            }
            case 3 -> {
                arity = 1;
                yield "get";
            }
            case 4 -> {
                arity = 1;
                yield "delete";
            }
            case 5 -> {
                arity = 1;
                yield "has";
            }
            case 6 -> {
                arity = 0;
                yield "clear";
            }
            case 7 -> {
                arity = 0;
                yield "keys";
            }
            case 8 -> {
                arity = 0;
                yield "values";
            }
            case 9 -> {
                arity = 0;
                yield "entries";
            }
            case 10 -> {
                arity = 1;
                yield "forEach";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, fnName, arity, cx);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (NativeSet.GETSIZE.equals(k)) {
            return 11;
        }
        if (SymbolKey.ITERATOR.equals(k)) {
            return 9;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 12;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "set" -> 2;
            case "get" -> 3;
            case "delete" -> 4;
            case "has" -> 5;
            case "clear" -> 6;
            case "keys" -> 7;
            case "values" -> 8;
            case "entries" -> 9;
            case "forEach" -> 10;
            default -> 0;
        };
    }
}

