/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.beautifulcampfires;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CampfireBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"beautifulcampfires");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"beautifulcampfires");
    private static Supplier<Block> ACACIA_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> BAMBOO_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.BAMBOO_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> BIRCH_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> CHERRY_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> CRIMSON_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.NETHER_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> DARK_OAK_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> JUNGLE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> MANGROVE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SPRUCE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> WARPED_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 1, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.NETHER_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(15)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_ACACIA_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_BAMBOO_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.BAMBOO_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_BIRCH_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_CHERRY_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.CHERRY_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_CRIMSON_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.NETHER_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_DARK_OAK_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_JUNGLE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_MANGROVE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_SPRUCE_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    private static Supplier<Block> SOUL_WARPED_CAMPFIRE_BLOCK = () -> new CampfireBlock(true, 2, BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.NETHER_WOOD).lightLevel(CampfireBlocks.createLightLevelFromLitBlockState(10)).noOcclusion().ignitedByLava());
    public static List<CampfireBlock> blockList = new ArrayList<CampfireBlock>();
    public static List<Item> itemsList = new ArrayList<Item>();

    private static ToIntFunction<BlockState> createLightLevelFromLitBlockState(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? p_50760_ : 0;
    }

    public static void registerBlocks() {
        CampfireBlocks.registerBlock("acacia_campfire", ACACIA_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("bamboo_campfire", BAMBOO_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("birch_campfire", BIRCH_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("cherry_campfire", CHERRY_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("crimson_campfire", CRIMSON_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("dark_oak_campfire", DARK_OAK_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("jungle_campfire", JUNGLE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("mangrove_campfire", MANGROVE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("spruce_campfire", SPRUCE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("warped_campfire", WARPED_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("acacia_soul_campfire", SOUL_ACACIA_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("bamboo_soul_campfire", SOUL_BAMBOO_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("birch_soul_campfire", SOUL_BIRCH_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("cherry_soul_campfire", SOUL_CHERRY_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("crimson_soul_campfire", SOUL_CRIMSON_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("dark_oak_soul_campfire", SOUL_DARK_OAK_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("jungle_soul_campfire", SOUL_JUNGLE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("mangrove_soul_campfire", SOUL_MANGROVE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("spruce_soul_campfire", SOUL_SPRUCE_CAMPFIRE_BLOCK);
        CampfireBlocks.registerBlock("warped_soul_campfire", SOUL_WARPED_CAMPFIRE_BLOCK);
    }

    private static void registerBlock(String id, Supplier<Block> block) {
        DeferredBlock registryBlock = BLOCKS.register(id, () -> {
            CampfireBlock campfireBlock = (CampfireBlock)block.get();
            blockList.add(campfireBlock);
            return campfireBlock;
        });
        ITEMS.register(id, () -> {
            BlockItem item = new BlockItem((Block)registryBlock.get(), new Item.Properties());
            itemsList.add((Item)item);
            return item;
        });
    }
}

