/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.utils;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmcore.impl.mixin.nbt.CompoundTagAccessor;

public class ShopNBTUtils {
    public static <T> void putList(CompoundTag nbt, String id, Collection<T> collection, Function<T, Tag> func) {
        if (collection.isEmpty()) {
            return;
        }
        ListTag tags = new ListTag();
        for (T t : collection) {
            tags.add((Object)func.apply(t));
        }
        nbt.put(id, (Tag)tags);
    }

    public static <T> List<T> getList(CompoundTag nbt, String id, Function<Tag, T> func) {
        if (!nbt.contains(id)) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        ListTag tags = (ListTag)nbt.get(id);
        for (Tag t : tags) {
            T f1 = func.apply(t);
            if (f1 == null) continue;
            list.add(f1);
        }
        return list;
    }

    public static <T> void getList(CompoundTag nbt, String id, Function<Tag, T> func, Collection<T> toAdd) {
        toAdd.addAll(ShopNBTUtils.getList(nbt, id, func));
    }

    public static <T> void getListWithClear(CompoundTag nbt, String id, Function<Tag, T> func, Collection<T> toAdd) {
        toAdd.clear();
        toAdd.addAll(ShopNBTUtils.getList(nbt, id, func));
    }

    public static void serializeItemStack(CompoundTag nbt, String id, ItemStack itemStack, HolderLookup.Provider provider) {
        CompoundTag itemData = new CompoundTag();
        try {
            CompoundTag itemTag = (CompoundTag)itemStack.save(provider);
            for (Map.Entry arrayData : ((CompoundTagAccessor)itemTag).getTags().entrySet()) {
                itemData.put((String)arrayData.getKey(), (Tag)arrayData.getValue());
            }
        }
        catch (Exception var8) {
            itemData.putString("id", "minecraft:air");
        }
        itemData.putInt("count", itemStack.getCount());
        nbt.put(id, (Tag)itemData);
    }

    public static ItemStack deserializeItemStack(CompoundTag nbt, String key, HolderLookup.Provider provider) {
        CompoundTag tag = nbt.getCompound(key);
        if (!tag.isEmpty()) {
            ItemStack stack = ItemStack.SINGLE_ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().orElse(ItemStack.EMPTY);
            stack.setCount(tag.getInt("count"));
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static double getDouble(CompoundTag nbt, String key, double defaultValue) {
        return ShopNBTUtils.getDouble(nbt, key).orElse(defaultValue);
    }

    public static Optional<Double> getDouble(CompoundTag nbt, String key) {
        return Optional.of(nbt.getDouble(key));
    }

    public static int getInt(CompoundTag nbt, String key, int defaultValue) {
        return ShopNBTUtils.getInt(nbt, key).orElse(defaultValue);
    }

    public static Optional<Integer> getInt(CompoundTag nbt, String key) {
        return Optional.of(nbt.getInt(key));
    }

    public static float getFloat(CompoundTag nbt, String key, float defaultValue) {
        return ShopNBTUtils.getFloat(nbt, key).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    public static Optional<Float> getFloat(CompoundTag nbt, String key) {
        return Optional.of(Float.valueOf(nbt.getFloat(key)));
    }

    public static boolean getBoolean(CompoundTag nbt, String key, boolean defaultValue) {
        return ShopNBTUtils.getBoolean(nbt, key).orElse(defaultValue);
    }

    public static Optional<Boolean> getBoolean(CompoundTag nbt, String key) {
        return Optional.of(nbt.getBoolean(key));
    }

    public static String getString(CompoundTag nbt, String key, String defaultValue) {
        return ShopNBTUtils.getString(nbt, key).orElse(defaultValue);
    }

    public static Optional<String> getString(CompoundTag nbt, String key) {
        return Optional.of(nbt.getString(key));
    }

    public static long getLong(CompoundTag nbt, String key, long defaultValue) {
        return ShopNBTUtils.getLong(nbt, key).orElse(defaultValue);
    }

    public static Optional<Long> getLong(CompoundTag nbt, String key) {
        return Optional.of(nbt.getLong(key));
    }

    public static byte getByte(CompoundTag nbt, String key, byte defaultValue) {
        return ShopNBTUtils.getByte(nbt, key).orElse(defaultValue);
    }

    public static Optional<Byte> getByte(CompoundTag nbt, String key) {
        return Optional.of(nbt.getByte(key));
    }

    public static short getShort(CompoundTag nbt, String key, short defaultValue) {
        return ShopNBTUtils.getShort(nbt, key).orElse(defaultValue);
    }

    public static Optional<Short> getShort(CompoundTag nbt, String key) {
        return Optional.of(nbt.getShort(key));
    }
}

