/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.shop.network.server;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.sixk.sdmshop.shop.BuyingWindow;
import net.sixk.sdmshop.shop.PlayerBasket;
import net.sixk.sdmshop.shop.ShopPage;
import net.sixk.sdmshop.shop.Tab.TovarTab;
import net.sixk.sdmshop.shop.Tovar.AbstractTovar;
import net.sixk.sdmshop.shop.Tovar.TovarList;
import net.sixk.sdmshop.utils.ShopDebugUtils;

public class SendShopDataS2C
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SendShopDataS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)"sdmshop", (String)"send_data"));
    public static final StreamCodec<FriendlyByteBuf, SendShopDataS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.TAG, SendShopDataS2C::getTovarTag, (StreamCodec)ByteBufCodecs.TAG, SendShopDataS2C::getTabTag, SendShopDataS2C::new);
    private final Tag tovarTag;
    private final Tag tabTag;

    public SendShopDataS2C(Tag tovarTag, Tag tabTag) {
        this.tovarTag = tovarTag;
        this.tabTag = tabTag;
    }

    public static void handle(SendShopDataS2C message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ShopDebugUtils.log("[SendShopDataS2C::handle]\n Tovar: {} \n Tab: {}", message.tovarTag, message.tabTag);
            TovarList.CLIENT.deserializeNBT((CompoundTag)message.tovarTag, (HolderLookup.Provider)context.registryAccess());
            TovarTab.CLIENT.deserializeNBT((CompoundTag)message.tabTag, (HolderLookup.Provider)context.registryAccess());
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof ScreenWrapper) {
                ScreenWrapper screenWrapper = (ScreenWrapper)screen;
                BaseScreen patt3$temp = screenWrapper.getGui();
                if (patt3$temp instanceof ShopPage) {
                    ShopPage shopPageScreen = (ShopPage)patt3$temp;
                    shopPageScreen.getGui().refreshWidgets();
                }
                if ((patt3$temp = screenWrapper.getGui()) instanceof PlayerBasket) {
                    PlayerBasket playerBasketScreen = (PlayerBasket)patt3$temp;
                    playerBasketScreen.getGui().refreshWidgets();
                }
                if ((patt3$temp = screenWrapper.getGui()) instanceof BuyingWindow) {
                    BuyingWindow buyingWindowScreen = (BuyingWindow)patt3$temp;
                    for (AbstractTovar tovar : TovarList.CLIENT.tovarList) {
                        if (!tovar.uuid.equals(BuyingWindow.tovar.uuid)) continue;
                        buyingWindowScreen.getGui().closeGui();
                        new BuyingWindow(tovar).openGui();
                    }
                }
            }
        });
    }

    public Tag getTovarTag() {
        return this.tovarTag;
    }

    public Tag getTabTag() {
        return this.tabTag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

