/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.shop.Tovar.TovarType;

import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmeconomy.api.EconomyAPI;
import net.sixk.sdmshop.shop.Tovar.AbstractTovar;

public class TovarXP
extends AbstractTovar {
    public int xpCount;
    public boolean isXPLVL;

    public TovarXP(UUID uuid, Icon icon, String tab, String currency, Integer cost, long limit, boolean toSell, int xpCount, boolean isXPLVL) {
        super(uuid, icon, tab, currency, cost, limit, toSell);
        this.xpCount = xpCount;
        this.isXPLVL = isXPLVL;
    }

    public TovarXP(UUID uuid, Icon icon, String tab, String currency, Integer cost, long limit, boolean toSell) {
        super(uuid, icon, tab, currency, cost, limit, toSell);
    }

    @Override
    public void buy(Player player, AbstractTovar tovar, long count) {
        long playerMoney = ((Double)EconomyAPI.getPlayerCurrencyServerData().getBalance((Player)player, (String)tovar.currency).value).longValue();
        long needMoney = (long)tovar.cost.intValue() * count;
        if (tovar.limit >= count || tovar.limit == -1L) {
            if (this.isXPLVL) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    needMoney = (long)tovar.cost.intValue() * count;
                    serverPlayer.setExperienceLevels((int)((long)player.experienceLevel + (long)this.xpCount * count));
                }
            } else {
                int experience;
                player.totalExperience = experience = (int)((long)TovarXP.getPlayerXP(player) + (long)this.xpCount * count);
                player.experienceLevel = TovarXP.getLevelForExperience(experience);
                int expForLevel = TovarXP.getExperienceForLevel(player.experienceLevel);
                player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
            }
            EconomyAPI.getPlayerCurrencyServerData().setCurrencyValue(player, tovar.currency, (double)(playerMoney - needMoney));
            if (tovar.limit != -1L) {
                tovar.limit -= count;
            }
        }
    }

    @Override
    public void sell(Player player, AbstractTovar tovar, long count) {
        if (tovar.limit >= count || tovar.limit == -1L) {
            if (this.isXPLVL) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.setExperienceLevels((int)((long)player.experienceLevel - (long)this.xpCount * count));
                }
            } else {
                int experience;
                player.totalExperience = experience = (int)((long)TovarXP.getPlayerXP(player) - (long)this.xpCount * count);
                player.experienceLevel = TovarXP.getLevelForExperience(experience);
                int expForLevel = TovarXP.getExperienceForLevel(player.experienceLevel);
                player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
            }
            EconomyAPI.getPlayerCurrencyServerData().addCurrencyValue(player, tovar.currency, (double)((long)tovar.cost.intValue() * count));
            if (tovar.limit != -1L) {
                tovar.limit -= count;
            }
        }
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)TovarXP.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = TovarXP.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return TovarXP.sum(level, 7, 2);
        }
        return level <= 30 ? 315 + TovarXP.sum(level - 15, 37, 5) : 1395 + TovarXP.sum(level - 30, 112, 9);
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    @Override
    public String getTitel() {
        return this.isXPLVL ? "Level : " + this.xpCount : "Xp : " + this.xpCount;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Object getItemStack() {
        return this.xpCount;
    }

    @Override
    public TagKey getTag() {
        return null;
    }

    @Override
    public AbstractTovar copy() {
        return null;
    }

    @Override
    public String getID() {
        return "XPType";
    }

    @Override
    public boolean getisXPLVL() {
        return this.isXPLVL;
    }

    @Override
    public void _serializeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("xpCount", this.xpCount);
        nbt.putBoolean("isXPLVL", this.isXPLVL);
    }

    @Override
    public void _deserializeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        this.xpCount = nbt.getInt("xpCount");
        this.isXPLVL = nbt.getBoolean("isXPLVL");
    }
}

