/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.shop.Tovar.TovarType;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmeconomy.api.EconomyAPI;
import net.sixk.sdmshop.shop.Tovar.AbstractTovar;
import net.sixk.sdmshop.utils.ShopNBTUtils;
import net.sixk.sdmshop.utils.item.ItemHandlerHelper;

public class TovarItem
extends AbstractTovar {
    public ItemStack item = ItemStack.EMPTY;
    public boolean byTag;
    public TagKey tag;

    public TovarItem(UUID uuid, Icon icon, String tab, String currency, Integer cost, long limit, boolean toSell, ItemStack item, boolean byTag, TagKey tag) {
        super(uuid, icon, tab, currency, cost, limit, toSell);
        this.item = item;
        this.byTag = byTag;
        this.tag = tag;
    }

    public TovarItem(UUID uuid, Icon icon, String tab, String currency, Integer cost, long limit, boolean toSell) {
        super(uuid, icon, tab, currency, cost, limit, toSell);
    }

    @Override
    public void buy(Player player, AbstractTovar tovar, long count) {
        long currency = ((Double)EconomyAPI.getPlayerCurrencyServerData().getBalance((Player)player, (String)tovar.currency).value).longValue();
        if ((tovar.limit >= count || tovar.limit == -1L) && currency >= (long)tovar.cost.intValue() * count) {
            EconomyAPI.getPlayerCurrencyServerData().addCurrencyValue(player, tovar.currency, (double)(-((long)tovar.cost.intValue() * count)));
            int w = 0;
            while ((long)w < count) {
                ItemHandlerHelper.giveItemToPlayer(player, this.item.copy());
                ++w;
            }
            if (tovar.limit != -1L) {
                tovar.limit -= count;
            }
        }
    }

    @Override
    public void sell(Player player, AbstractTovar tovar, long count) {
        if (!this.byTag) {
            if (tovar.limit < count && tovar.limit != -1L) {
                return;
            }
            EconomyAPI.getPlayerCurrencyServerData().addCurrencyValue(player, tovar.currency, (double)((long)tovar.cost.intValue() * count));
            TovarItem.sellItem(player, (int)(count * (long)this.item.getCount()), this.item);
            if (tovar.limit != -1L) {
                tovar.limit -= count;
            }
        } else {
            int amountItems;
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (amountItems = 0; amountItems < player.getInventory().getContainerSize(); ++amountItems) {
                if (!player.getInventory().getItem(amountItems).is(this.tag)) continue;
                stackList.add(player.getInventory().getItem(amountItems));
            }
            amountItems = 0;
            Iterator var7 = stackList.iterator();
            while (true) {
                if (!var7.hasNext()) {
                    int amount;
                    int n = amount = (long)amountItems >= (long)this.item.getCount() * count ? (int)((long)this.item.getCount() * count) : 0;
                    if (amountItems == 0 || amount == 0) {
                        return;
                    }
                    if (tovar.limit < count && tovar.limit != -1L) {
                        return;
                    }
                    if (amount <= 0) {
                        return;
                    }
                    if (TovarItem.sellItem(player, amount, (TagKey<Item>)this.tag)) {
                        EconomyAPI.getPlayerCurrencyServerData().addCurrencyValue(player, tovar.currency, (double)((long)tovar.cost.intValue() * count));
                    }
                    if (tovar.limit == -1L) break;
                    tovar.limit -= count;
                    break;
                }
                ItemStack item = (ItemStack)var7.next();
                amountItems += item.getCount();
            }
        }
    }

    @Override
    public String getTitel() {
        return this.item.getDisplayName().getString().replace("[", "").replace("]", "");
    }

    public static boolean sellItem(Player p, int amm, ItemStack item) {
        int ammountleft;
        int totalamm = 0;
        for (ammountleft = 0; ammountleft < p.getInventory().getContainerSize(); ++ammountleft) {
            p.getInventory().getItem(ammountleft);
            if (!ItemStack.isSameItem((ItemStack)p.getInventory().getItem(ammountleft), (ItemStack)item) || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)p.getInventory().getItem(ammountleft))) continue;
            totalamm += p.getInventory().getItem(ammountleft).getCount();
        }
        if (totalamm == 0) {
            return false;
        }
        if (totalamm < amm) {
            return false;
        }
        ammountleft = amm;
        for (int a = 0; a < p.getInventory().getContainerSize(); ++a) {
            if (ammountleft == 0) {
                return true;
            }
            p.getInventory().getItem(a);
            if (!ItemStack.isSameItem((ItemStack)p.getInventory().getItem(a), (ItemStack)item) || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)p.getInventory().getItem(a))) continue;
            if (p.getInventory().getItem(a).getCount() < ammountleft) {
                ammountleft -= p.getInventory().getItem(a).getCount();
                p.getInventory().setItem(a, ItemStack.EMPTY);
            }
            p.getInventory().getItem(a);
            if (p.getInventory().getItem(a).getCount() == ammountleft) {
                p.getInventory().setItem(a, ItemStack.EMPTY);
                return true;
            }
            if (p.getInventory().getItem(a).getCount() <= ammountleft) continue;
            p.getInventory().getItem(a);
            p.getInventory().getItem(a).setCount(p.getInventory().getItem(a).getCount() - ammountleft);
            return true;
        }
        return false;
    }

    public static boolean sellItem(Player p, int amm, TagKey<Item> item) {
        int ammountleft;
        int totalamm = 0;
        for (ammountleft = 0; ammountleft < p.getInventory().getContainerSize(); ++ammountleft) {
            p.getInventory().getItem(ammountleft);
            if (!p.getInventory().getItem(ammountleft).is(item)) continue;
            totalamm += p.getInventory().getItem(ammountleft).getCount();
        }
        if (totalamm == 0) {
            return false;
        }
        if (totalamm < amm) {
            return false;
        }
        ammountleft = amm;
        for (int a = 0; a < p.getInventory().getContainerSize(); ++a) {
            if (ammountleft == 0) {
                return true;
            }
            p.getInventory().getItem(a);
            if (!p.getInventory().getItem(a).is(item)) continue;
            if (p.getInventory().getItem(a).getCount() < ammountleft) {
                ammountleft -= p.getInventory().getItem(a).getCount();
                p.getInventory().setItem(a, ItemStack.EMPTY);
            }
            p.getInventory().getItem(a);
            if (p.getInventory().getItem(a).getCount() == ammountleft) {
                p.getInventory().setItem(a, ItemStack.EMPTY);
                return true;
            }
            if (p.getInventory().getItem(a).getCount() <= ammountleft) continue;
            p.getInventory().getItem(a);
            p.getInventory().getItem(a).setCount(p.getInventory().getItem(a).getCount() - ammountleft);
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return ItemIcon.getItemIcon((ItemStack)this.item);
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public TagKey getTag() {
        return this.tag;
    }

    @Override
    public AbstractTovar copy() {
        return null;
    }

    @Override
    public String getID() {
        return "ItemType";
    }

    @Override
    public boolean getisXPLVL() {
        return this.byTag;
    }

    @Override
    public void _serializeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        ShopNBTUtils.serializeItemStack(nbt, "item", this.item, provider);
        if (this.tag != null) {
            nbt.putString("tag", this.tag.location().toString());
        }
        nbt.putBoolean("byTag", this.byTag);
    }

    @Override
    public void _deserializeNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("tag")) {
            String t1 = nbt.getString("tag");
            for (Pair tagKeyNamedPair : BuiltInRegistries.ITEM.getTags().toList()) {
                if (!((TagKey)tagKeyNamedPair.getFirst()).location().toString().equals(t1)) continue;
                this.tag = (TagKey)tagKeyNamedPair.getFirst();
                break;
            }
        }
        this.item = ShopNBTUtils.deserializeItemStack(nbt, "item", provider);
        this.byTag = nbt.getBoolean("byTag");
    }
}

