/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.shop;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmeconomy.api.EconomyAPI;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrencyData;
import net.sixik.sdmeconomy.economyData.CurrencyPlayerData;
import net.sixik.sdmeconomy.network.SDMEconomyNetwork;
import net.sixk.sdmshop.SDMShop;
import net.sixk.sdmshop.data.config.Config;
import net.sixk.sdmshop.shop.network.server.SendConfigS2C;
import net.sixk.sdmshop.shop.network.server.SendOpenShopScreenS2C;
import net.sixk.sdmshop.utils.ShopNetworkUtils;

public class ShopComands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sdmshop").then(((LiteralArgumentBuilder)Commands.literal((String)"edit_mode").requires(source -> source.hasPermission(2))).executes(context -> ShopComands.editMode((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"reloadConfig").requires(source -> source.hasPermission(2))).executes(context -> ShopComands.reloadClient((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"pay").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"currency", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String key : ((CurrencyData)EconomyAPI.getAllCurrency().value).currencies.stream().map(Currency::getName).toList()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"money", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(context -> ShopComands.pay((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"currency", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String key : ((CurrencyData)EconomyAPI.getAllCurrency().value).currencies.stream().map(Currency::getName).toList()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"money", (ArgumentType)LongArgumentType.longArg()).executes(context -> ShopComands.add((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"currency", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String key : ((CurrencyData)EconomyAPI.getAllCurrency().value).currencies.stream().map(Currency::getName).toList()) {
                builder.suggest(key);
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"money", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> ShopComands.set((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"open_shop").requires(source -> source.hasPermission(2))).executes(context -> ShopComands.openShop((CommandSourceStack)context.getSource(), null))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> ShopComands.openShop((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"))))));
    }

    private static int openShop(CommandSourceStack source, Collection<ServerPlayer> profiles) {
        if (profiles != null) {
            for (ServerPlayer profile : profiles) {
                SDMEconomyNetwork.sendTo((ServerPlayer)profile, (CustomPacketPayload)new SendOpenShopScreenS2C(true));
            }
        } else if (source.getPlayer() != null) {
            SDMEconomyNetwork.sendTo((ServerPlayer)source.getPlayer(), (CustomPacketPayload)new SendOpenShopScreenS2C(true));
        }
        return 1;
    }

    private static int editMode(CommandSourceStack source) {
        if (source.getPlayer() != null) {
            SDMShop.setEditMode(source.getPlayer(), !SDMShop.isEditMode((Player)source.getPlayer()));
            source.sendSuccess(() -> Component.literal((String)("Edit mode is " + SDMShop.isEditMode((Player)source.getPlayer()))), false);
        }
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        if (source.getPlayer() != null) {
            source.sendSuccess(() -> Component.literal((String)"Start Reload"), false);
            Config.loadConfig(false);
            SDMEconomyNetwork.sendTo((ServerPlayer)source.getPlayer(), (CustomPacketPayload)new SendConfigS2C(true));
        }
        return 1;
    }

    private static int pay(CommandContext<CommandSourceStack> context, ServerPlayer from, ServerPlayer to, long money) {
        String currency = StringArgumentType.getString(context, (String)"currency");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (from.getUUID().equals(to.getUUID())) {
            source.sendFailure((Component)Component.literal((String)"You can't send money to yourself"));
            return 1;
        }
        if (ShopComands.getMoney((Player)from, currency) >= money) {
            ShopComands.setMoney((Player)from, currency, ShopComands.getMoney((Player)from, currency) - money);
            ShopComands.setMoney((Player)to, currency, ShopComands.getMoney((Player)to, currency) + money);
            source.sendSuccess(() -> Component.literal((String)"Money sended !"), false);
            return 0;
        }
        source.sendFailure((Component)Component.literal((String)"Not enough money"));
        return 1;
    }

    private static int add(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, long money) {
        if (money == 0L) {
            return 0;
        }
        String currency = StringArgumentType.getString(context, (String)"currency");
        for (ServerPlayer player : players) {
            EconomyAPI.getPlayerCurrencyServerData().addCurrencyValue((Player)player, currency, (double)money);
            EconomyAPI.syncPlayer((ServerPlayer)player);
            ShopNetworkUtils.sendShopDataS2C(player, (RegistryAccess)player.getServer().registryAccess());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                MutableComponent var10000 = Component.literal((String)(player.getScoreboardName() + ": "));
                Optional var10001 = EconomyAPI.getPlayerCurrencyServerData().getPlayerCurrency((Player)player, currency);
                return var10000.append((Component)Component.literal((String)(((CurrencyPlayerData.PlayerCurrency)var10001.get()).currency.symbol.value + " ")).append(String.valueOf(ShopComands.getMoney((Player)player, currency))));
            }, false);
        }
        return players.size();
    }

    private static int set(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, long money) {
        String currency = StringArgumentType.getString(context, (String)"currency");
        for (ServerPlayer player : players) {
            ShopComands.setMoney((Player)player, currency, money);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                MutableComponent var10000 = Component.literal((String)(player.getScoreboardName() + ": "));
                Optional var10001 = EconomyAPI.getPlayerCurrencyServerData().getPlayerCurrency((Player)player, currency);
                return var10000.append((Component)Component.literal((String)(((CurrencyPlayerData.PlayerCurrency)var10001.get()).currency.symbol.value + " ")).append(String.valueOf(ShopComands.getMoney((Player)player, currency))));
            }, false);
        }
        return players.size();
    }

    public static void setMoney(Player player, String currency, long money) {
        EconomyAPI.getPlayerCurrencyServerData().setCurrencyValue(player, currency, (double)money);
        EconomyAPI.syncPlayer((ServerPlayer)((ServerPlayer)player));
        ShopNetworkUtils.sendShopDataS2C((ServerPlayer)player, player.registryAccess());
    }

    public static long getMoney(Player player, String currency) {
        return ((Double)EconomyAPI.getPlayerCurrencyServerData().getBalance((Player)player, (String)currency).value).longValue();
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> commandSourceStackCommandDispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        ShopComands.registerCommands(commandSourceStackCommandDispatcher);
    }
}

