/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop.data.config;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import net.sixk.sdmshop.data.config.ConfigFile;

public class Config {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"sdmshop-common");
    public static final BooleanValue DISABLE_KEYBIND = CONFIG.addBoolean("disable_key_bind", false);
    public static final BooleanValue STYLES = CONFIG.addBoolean("isModern", false);

    public static void init() {
        Config.loadConfig(true);
    }

    public static void reload() {
        CONFIG.load(Config.getClientConfig());
    }

    public static void loadConfig(boolean client) {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)Config.getModFolder(), (String)"sdmshop");
        if (client) {
            ConfigFile.CLIENT.disableKeyBind = (Boolean)DISABLE_KEYBIND.get();
            ConfigFile.CLIENT.style = (Boolean)STYLES.get();
        } else {
            ConfigFile.SERVER.disableKeyBind = (Boolean)DISABLE_KEYBIND.get();
            ConfigFile.SERVER.style = (Boolean)STYLES.get();
        }
    }

    public static Path getModFolder() {
        return Platform.getConfigFolder().resolve("SDMShop");
    }

    public static Path getClientConfig() {
        return Config.getModFolder().resolve("sdmshop-common.snbt");
    }

    static {
        SNBTConfig sNBTConfig = CONFIG.addGroup("CUSTOM");
    }
}

