/*
 * Decompiled with CFR 0.152.
 */
package net.sixk.sdmshop;

import com.mojang.datafixers.util.Function7;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmeconomy.api.CustomCurrencies;
import net.sixik.sdmeconomy.api.EconomyAPI;
import net.sixik.sdmeconomy.network.SDMEconomyNetwork;
import net.sixk.sdmshop.SDMShopClient;
import net.sixk.sdmshop.data.config.Config;
import net.sixk.sdmshop.shop.ShopComands;
import net.sixk.sdmshop.shop.Tab.TovarTab;
import net.sixk.sdmshop.shop.Tovar.AbstractTovar;
import net.sixk.sdmshop.shop.Tovar.TovarList;
import net.sixk.sdmshop.shop.Tovar.TovarType.TovarCommand;
import net.sixk.sdmshop.shop.Tovar.TovarType.TovarItem;
import net.sixk.sdmshop.shop.Tovar.TovarType.TovarTypeRegister;
import net.sixk.sdmshop.shop.Tovar.TovarType.TovarXP;
import net.sixk.sdmshop.shop.currency.SDMCoin;
import net.sixk.sdmshop.shop.network.ModNetwork;
import net.sixk.sdmshop.shop.network.server.SendEditModeS2C;
import net.sixk.sdmshop.utils.ShopNetworkUtils;
import org.slf4j.Logger;

public class SDMShop {
    public static final String MODID = "sdmshop";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static boolean isSerialize;

    public static void init() {
        Config.init();
        ModNetwork.init();
        SDMShop.modEvents();
        CommandRegistrationEvent.EVENT.register(ShopComands::registerCommands);
        CustomCurrencies.CURRENCIES.put("sdmcoin", SDMCoin::new);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> SDMShopClient::init);
        TovarTypeRegister.register("ItemType", (Function7<UUID, Icon, String, String, Integer, Long, Boolean, AbstractTovar>)((Function7)TovarItem::new));
        TovarTypeRegister.register("XPType", (Function7<UUID, Icon, String, String, Integer, Long, Boolean, AbstractTovar>)((Function7)TovarXP::new));
        TovarTypeRegister.register("CommandType", (Function7<UUID, Icon, String, String, Integer, Long, Boolean, AbstractTovar>)((Function7)TovarCommand::new));
    }

    public static void modEvents() {
        LifecycleEvent.SERVER_STARTED.register(server -> {
            TovarTab.SERVER = new TovarTab();
            TovarList.SERVER = new TovarList();
            isSerialize = false;
            if (!server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").resolve("SDMTovarTab.sdm").toFile().exists()) {
                SDMShop.saveData(server);
            }
            try {
                CompoundTag w1 = NbtIo.read((Path)server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").resolve("SDMTovarTab.sdm"));
                if (w1 != null) {
                    TovarTab.SERVER.deserializeNBT(w1, (HolderLookup.Provider)server.registryAccess());
                }
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        });
        LifecycleEvent.SERVER_STOPPED.register(SDMShop::saveData);
        PlayerEvent.PLAYER_JOIN.register(serverPlayer -> {
            try {
                CompoundTag w2 = NbtIo.read((Path)serverPlayer.getServer().getWorldPath(LevelResource.ROOT).resolve("SDMShopData").resolve("SDMTovarList.sdm"));
                if (w2 != null && !isSerialize) {
                    isSerialize = true;
                    TovarList.SERVER.deserializeNBT(w2, (HolderLookup.Provider)serverPlayer.getServer().registryAccess());
                }
                ShopNetworkUtils.sendShopDataS2C(serverPlayer, serverPlayer.registryAccess());
                SDMEconomyNetwork.sendTo((ServerPlayer)serverPlayer, (CustomPacketPayload)new SendEditModeS2C(SDMShop.isEditMode((Player)serverPlayer)));
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        });
    }

    public static void saveData(MinecraftServer server) {
        if (!server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").toFile().exists()) {
            server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").toFile().mkdir();
        }
        if (TovarTab.SERVER != null) {
            try {
                NbtIo.write((CompoundTag)TovarTab.SERVER.serializeNBT((HolderLookup.Provider)server.registryAccess()), (Path)server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").resolve("SDMTovarTab.sdm"));
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        }
        if (TovarList.SERVER != null) {
            try {
                NbtIo.write((CompoundTag)TovarList.SERVER.serializeNBT((HolderLookup.Provider)server.registryAccess()), (Path)server.getWorldPath(LevelResource.ROOT).resolve("SDMShopData").resolve("SDMTovarList.sdm"));
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
        }
    }

    public static boolean isEditMode(Player player) {
        CompoundTag nbt = EconomyAPI.getCustomData((Player)player);
        if (nbt.contains("edit_mode")) {
            System.out.println("1:" + nbt.getBoolean("edit_mode"));
            return nbt.getBoolean("edit_mode");
        }
        nbt.putBoolean("edit_mode", false);
        return false;
    }

    public static boolean isEditMode() {
        CompoundTag nbt = EconomyAPI.getCustomData((Player)SDMShopClient.getPlayer());
        return nbt.contains("edit_mode") && nbt.getBoolean("edit_mode");
    }

    public static void setEditMode(ServerPlayer player, boolean value) {
        EconomyAPI.updateCustomData((ServerPlayer)player, s -> s.putBoolean("edit_mode", value));
    }
}

