/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lmft.utils;

import io.wispforest.lmft.LMFTCommon;
import io.wispforest.lmft.utils.PathUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MethodHandleUtils {
    public static MethodHandle findMethod(MethodHandles.Lookup lookup, Class<?> clazz, MethodType mt, String ... methodNames) {
        return MethodHandleUtils.findHandle(lookup, MethodHandles.Lookup::findVirtual, clazz, mt, methodNames);
    }

    @Nullable
    public static MethodHandle findStaticMethod(MethodHandles.Lookup lookup, Class<?> clazz, MethodType mt, String ... methodNames) {
        return MethodHandleUtils.findHandle(lookup, MethodHandles.Lookup::findStatic, clazz, mt, methodNames);
    }

    public static MethodHandle findStaticConstructor(MethodHandles.Lookup lookup, Class<?> clazz, List<Class<?>> parameterTypes, String ... methodNames) {
        return MethodHandleUtils.findStaticMethod(lookup, clazz, MethodType.methodType(clazz, parameterTypes), methodNames);
    }

    public static MethodHandle findConstructor(MethodHandles.Lookup lookup, Class<?> clazz, Class<?> ... parameterTypes) {
        return MethodHandleUtils.findHandle(lookup, MethodHandles.Lookup::findConstructor, clazz, MethodType.methodType(Void.TYPE, parameterTypes));
    }

    public static Class<?> findClass(String ... targetNames) {
        for (String targetName : targetNames) {
            try {
                return Class.forName(targetName, false, PathUtils.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static MethodHandle findHandle(MethodHandles.Lookup lookup, NamedHandleLookup handleLookup, Class<?> clazz, MethodType mt, String ... methodNames) {
        for (String methodName : methodNames) {
            MethodHandle handle = MethodHandleUtils.findHandle(lookup, handleLookup.generic(methodName), clazz, mt);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    public static MethodHandle findHandle(MethodHandles.Lookup lookup, HandleLookup handleLookup, Class<?> clazz, MethodType mt) {
        try {
            return handleLookup.findHandle(lookup, clazz, mt);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("[Load My F***ing Tags]: Unable to locate the a method handle for " + clazz.getName() + "  due to an error: ", e);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    @Nullable
    public static <T> T wrapForErrors(String methodName, MethodHandleExecution execution) {
        try {
            return (T)execution.get();
        }
        catch (Throwable e) {
            LMFTCommon.LOGGER.error("[Load My F***ing Tags]: Unable to invoke '{}' as an error occurred: ", (Object)methodName, (Object)e);
            return null;
        }
    }

    public static interface NamedHandleLookup {
        public MethodHandle findHandle(MethodHandles.Lookup var1, Class<?> var2, String var3, MethodType var4) throws ReflectiveOperationException;

        default public HandleLookup generic(String methodName) {
            return (lookup, clazz, mt) -> this.findHandle(lookup, clazz, methodName, mt);
        }
    }

    public static interface HandleLookup {
        public MethodHandle findHandle(MethodHandles.Lookup var1, Class<?> var2, MethodType var3) throws ReflectiveOperationException;
    }

    public static interface MethodHandleExecution {
        public Object get() throws Throwable;
    }
}

