/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.OverlapCheckData;
import com.faboslav.structurify.common.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.common.world.level.structure.checks.StructureCheckData;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public final class StructureOverlapCheck {
    @Nullable
    public static OverlapCheckData getOverlapCheckData(StructureCheckData structureCheckData) {
        OverlapCheckData structureOverlapCheckData;
        OverlapCheckData namespaceOverlapCheckData;
        StructurifyStructure structure = structureCheckData.getStructure();
        ResourceLocation structureId = structureCheckData.getStructureId();
        StructureNamespaceData structureNamespaceData = structure.structurify$getStructureNamespaceData(structureId);
        StructureData structureData = structure.structurify$getStructureData(structureId);
        OverlapCheckData overlapCheckDataToCheck = null;
        if (structureNamespaceData != null && (namespaceOverlapCheckData = structureNamespaceData.getOverlapCheckData()).isExcludedFromOverlapPrevention()) {
            overlapCheckDataToCheck = namespaceOverlapCheckData;
        }
        if (structureData != null && (structureOverlapCheckData = structureData.getOverlapCheckData()).isExcludedFromOverlapPrevention()) {
            overlapCheckDataToCheck = structureOverlapCheckData;
        }
        return overlapCheckDataToCheck;
    }

    public static boolean canDoOverlapCheck(StructureCheckData structureCheckData, @Nullable OverlapCheckData overlapCheckData) {
        if (!Structurify.getConfig().preventStructureOverlap) {
            return false;
        }
        StructureData structureData = structureCheckData.getStructure().structurify$getStructureData();
        if (structureData == null) {
            return false;
        }
        return overlapCheckData == null || !overlapCheckData.isExcludedFromOverlapPrevention();
    }

    public static boolean checkForOverlap(StructureCheckData structureCheckData, OverlapCheckData overlapCheckData, StructurifyChunkGenerator structurifyChunkGenerator) {
        StructureStart start = structureCheckData.getStructureStart();
        long[] structureCells = StructureOverlapCheck.getStructurePiecesSections(start);
        long structureCenter = start.getBoundingBox().getCenter().asLong();
        boolean overlapCheckResult = !StructureOverlapCheck.claimStructureSections(structurifyChunkGenerator, structureCells, structureCheckData.getStructureId(), structureCenter);
        return overlapCheckResult;
    }

    private static long[] getStructurePiecesSections(StructureStart start) {
        HashSet<Long> structurePieceSectionUniqueKeys = new HashSet<Long>();
        for (StructurePiece piece : start.getPieces()) {
            BoundingBox b = piece.getBoundingBox();
            int minSx = SectionPos.blockToSectionCoord((int)b.minX());
            int maxSx = SectionPos.blockToSectionCoord((int)b.maxX());
            int minSz = SectionPos.blockToSectionCoord((int)b.minZ());
            int maxSz = SectionPos.blockToSectionCoord((int)b.maxZ());
            int minSy = SectionPos.blockToSectionCoord((int)b.minY());
            int maxSy = SectionPos.blockToSectionCoord((int)b.maxY());
            for (int sz = minSz; sz <= maxSz; ++sz) {
                for (int sx = minSx; sx <= maxSx; ++sx) {
                    for (int sy = minSy; sy <= maxSy; ++sy) {
                        structurePieceSectionUniqueKeys.add(SectionPos.asLong((int)sx, (int)sy, (int)sz));
                    }
                }
            }
        }
        long[] structurePieceSectionKeys = new long[structurePieceSectionUniqueKeys.size()];
        int i = 0;
        for (Long structurePieceSectionKey : structurePieceSectionUniqueKeys) {
            structurePieceSectionKeys[i++] = structurePieceSectionKey;
        }
        return structurePieceSectionKeys;
    }

    private static boolean claimStructureSections(StructurifyChunkGenerator gen, long[] sectionKeysToClaim, ResourceLocation structureId, long structureCenter) {
        long token = ThreadLocalRandom.current().nextLong();
        StructureSectionClaim claim = new StructureSectionClaim(token, structureId.toString(), structureCenter);
        long[] claimed = new long[sectionKeysToClaim.length];
        for (int acquired = 0; acquired < sectionKeysToClaim.length; ++acquired) {
            long key;
            claimed[acquired] = key = sectionKeysToClaim[acquired];
            StructureSectionClaim prev = gen.structurify$getStructureSectionClaims().putIfAbsent(key, claim);
            if (prev == null || structureId.toString().equals(prev.structureId()) && structureCenter == prev.structureCenter()) continue;
            for (int i = 0; i < acquired; ++i) {
                gen.structurify$getStructureSectionClaims().remove(claimed[i], claim);
            }
            return false;
        }
        return true;
    }
}

