/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureSetData;
import net.minecraft.resources.ResourceLocation;

public final class RandomSpreadUtil {
    private static StructureSetData getStructureSetData(ResourceLocation structureSetResourceLocation) {
        if (structureSetResourceLocation == null || !Structurify.getConfig().getStructureSetData().containsKey(structureSetResourceLocation.toString())) {
            return null;
        }
        return Structurify.getConfig().getStructureSetData().get(structureSetResourceLocation.toString());
    }

    public static int getModifiedSalt(ResourceLocation structureSetResourceLocation, int originalSalt) {
        StructureSetData structureSetData = RandomSpreadUtil.getStructureSetData(structureSetResourceLocation);
        if (structureSetData == null) {
            return originalSalt;
        }
        return structureSetData.getSalt();
    }

    public static float getModifiedFrequency(ResourceLocation structureSetResourceLocation, float originalFrequency) {
        StructureSetData structureSetData = RandomSpreadUtil.getStructureSetData(structureSetResourceLocation);
        if (structureSetData == null) {
            return originalFrequency;
        }
        return structureSetData.getFrequency();
    }

    public static int getModifiedSpacing(ResourceLocation structureSetResourceLocation, int originalSpacing) {
        StructureSetData structureSetData = RandomSpreadUtil.getStructureSetData(structureSetResourceLocation);
        return RandomSpreadUtil.getModifiedSpacing(structureSetData, originalSpacing);
    }

    public static int getModifiedSpacing(StructureSetData structureSetData, int originalSpacing) {
        int spacing = originalSpacing;
        if (Structurify.getConfig().enableGlobalSpacingAndSeparationModifier) {
            spacing = structureSetData != null && structureSetData.overrideGlobalSpacingAndSeparationModifier() ? structureSetData.getSpacing() : (int)((double)spacing * Structurify.getConfig().globalSpacingAndSeparationModifier);
        } else if (structureSetData != null) {
            spacing = structureSetData.getSpacing();
        }
        return RandomSpreadUtil.getCorrectedModifiedSpacingValue(spacing);
    }

    public static int getModifiedSeparation(ResourceLocation structureSetResourceLocation, int spacing, int originalSeparation) {
        StructureSetData structureSetData = RandomSpreadUtil.getStructureSetData(structureSetResourceLocation);
        return RandomSpreadUtil.getModifiedSeparation(structureSetData, spacing, originalSeparation);
    }

    public static int getModifiedSeparation(StructureSetData structureSetData, int spacing, int originalSeparation) {
        int separation = originalSeparation;
        if (Structurify.getConfig().enableGlobalSpacingAndSeparationModifier) {
            separation = structureSetData != null && structureSetData.overrideGlobalSpacingAndSeparationModifier() ? structureSetData.getSeparation() : (int)((double)separation * Structurify.getConfig().globalSpacingAndSeparationModifier);
        } else if (structureSetData != null) {
            separation = structureSetData.getSeparation();
        }
        return RandomSpreadUtil.getCorrectedModifiedSeparationValue(spacing, separation);
    }

    private static int getCorrectedModifiedSpacingValue(int spacingValue) {
        return Math.max(1, spacingValue);
    }

    private static int getCorrectedModifiedSeparationValue(int spacing, int separation) {
        if ((separation = Math.max(0, separation)) >= spacing) {
            separation = spacing - 1;
        }
        return separation;
    }
}

