/*
 * Decompiled with CFR 0.152.
 */
package owens.oobjloader;

import java.util.ArrayList;

public class StringUtils {
    public static int skipWhiteSpace(int mCount, char[] messageChars, String errMsg) {
        while (mCount < messageChars.length && (messageChars[mCount] == ' ' || messageChars[mCount] == '\n' || messageChars[mCount] == '\t')) {
            ++mCount;
        }
        if (errMsg != null && mCount >= messageChars.length) {
            return -1;
        }
        return mCount;
    }

    public static float[] parseFloatList(int numFloats, String list, int startIndex) {
        int itemEnd;
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        float[] returnArray = new float[numFloats];
        int returnArrayCount = 0;
        char[] listChars = new char[list.length()];
        list.getChars(0, list.length(), listChars, 0);
        int listLength = listChars.length;
        int count = startIndex;
        while (count < listLength && (count = (itemEnd = StringUtils.skipWhiteSpace(count, listChars, null))) < listLength) {
            int itemStart = count;
            while (itemEnd < listLength && listChars[itemEnd] != ' ' && listChars[itemEnd] != '\n' && listChars[itemEnd] != '\t') {
                ++itemEnd;
            }
            int itemLength = itemEnd - itemStart;
            returnArray[returnArrayCount++] = Float.parseFloat(new String(listChars, itemStart, itemLength));
            if (returnArrayCount >= numFloats) break;
            count = itemEnd;
        }
        return returnArray;
    }

    public static int[] parseListVerticeNTuples(String list, int expectedValuesPerTuple) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        String[] vertexStrings = StringUtils.parseWhitespaceList(list);
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        Integer emptyMarker = Integer.MIN_VALUE;
        for (String string : vertexStrings) {
            StringUtils.parseVerticeNTuple(string, returnList, emptyMarker, expectedValuesPerTuple);
        }
        int[] returnArray = new int[returnList.size()];
        for (int loopi = 0; loopi < returnList.size(); ++loopi) {
            returnArray[loopi] = returnList.get(loopi);
        }
        return returnArray;
    }

    private static void parseVerticeNTuple(String list, ArrayList<Integer> returnList, Integer emptyMarker, int expectedValueCount) {
        String[] numbers = StringUtils.parseList('/', list);
        int foundCount = 0;
        for (int index = 0; index < numbers.length; ++index) {
            if (numbers[index].trim().isEmpty()) {
                returnList.add(emptyMarker);
            } else {
                returnList.add(Integer.parseInt(numbers[index]));
            }
            ++foundCount;
        }
        while (foundCount < expectedValueCount) {
            returnList.add(emptyMarker);
            ++foundCount;
        }
    }

    public static String[] parseList(char delim, String list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<String> returnVec = new ArrayList<String>();
        char[] listChars = new char[list.length()];
        list.getChars(0, list.length(), listChars, 0);
        int count = 0;
        while (count < listChars.length) {
            int itemStart;
            int itemEnd;
            for (itemEnd = itemStart = count; itemEnd < listChars.length && delim != listChars[itemEnd]; ++itemEnd) {
            }
            String newItem = new String(listChars, itemStart, itemEnd - itemStart);
            count = ++itemEnd;
            returnVec.add(newItem);
        }
        String[] returnArray = new String[1];
        returnArray = (String[])returnVec.toArray((Object[])returnArray);
        return returnArray;
    }

    public static String[] parseWhitespaceList(String list) {
        int itemEnd;
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<String> returnVec = new ArrayList<String>();
        char[] listChars = new char[list.length()];
        list.getChars(0, list.length(), listChars, 0);
        int count = 0;
        while (count < listChars.length && (count = (itemEnd = StringUtils.skipWhiteSpace(count, listChars, null))) < listChars.length) {
            int itemStart = count;
            while (itemEnd < listChars.length && listChars[itemEnd] != ' ' && listChars[itemEnd] != '\n' && listChars[itemEnd] != '\t') {
                ++itemEnd;
            }
            String newItem = new String(listChars, itemStart, itemEnd - itemStart);
            count = ++itemEnd;
            returnVec.add(newItem);
        }
        String[] returnArray = new String[1];
        returnArray = (String[])returnVec.toArray((Object[])returnArray);
        return returnArray;
    }
}

