/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class PaintingsLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, Map.Entry<Painting, Resource>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson GSON = new GsonBuilder().create();
    private static final String dataType = "paintings";
    private static final int dataTypeLength = "paintings".length() + 1;
    private static final int fileSuffixLength = ".json".length();
    protected static final ResourceLocation ID = Main.locate("paintings");

    protected Map<ResourceLocation, Map.Entry<Painting, Resource>> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Map.Entry<Painting, Resource>> map = new HashMap<ResourceLocation, Map.Entry<Painting, Resource>>();
        Map resources = manager.listResources(dataType, path -> path.getPath().endsWith(".png"));
        for (Map.Entry entry : resources.entrySet()) {
            String string = ((ResourceLocation)entry.getKey()).getPath();
            ResourceLocation imageIdentifier = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)string.substring(dataTypeLength, string.length() - fileSuffixLength));
            try {
                ResourceLocation jsonIdentifier = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)string.replace(".png", ".json"));
                Optional resource = manager.getResource(jsonIdentifier);
                if (resource.isEmpty()) {
                    LOGGER.error("Couldn't load painting {} from {}: no resource present", (Object)imageIdentifier, entry.getKey());
                    continue;
                }
                InputStreamReader reader = new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8);
                JsonObject jsonElement = Objects.requireNonNull((JsonElement)GsonHelper.fromJson((Gson)this.GSON, (Reader)reader, JsonElement.class)).getAsJsonObject();
                int width = GsonHelper.getAsInt((JsonObject)jsonElement, (String)"width", (int)1);
                int height = GsonHelper.getAsInt((JsonObject)jsonElement, (String)"height", (int)1);
                int resolution = GsonHelper.getAsInt((JsonObject)jsonElement, (String)"resolution", (int)32);
                String name = GsonHelper.getAsString((JsonObject)jsonElement, (String)"name", (String)"unknown");
                String author = GsonHelper.getAsString((JsonObject)jsonElement, (String)"author", (String)"unknown");
                boolean graffiti = GsonHelper.getAsBoolean((JsonObject)jsonElement, (String)"graffiti", (boolean)false);
                String hash = ((ResourceLocation)entry.getKey()).toString().replaceAll("[^a-zA-Z\\d]", "");
                EnumSet<Painting.Flag> flags = EnumSet.noneOf(Painting.Flag.class);
                if (graffiti) {
                    flags.add(Painting.Flag.GRAFFITI);
                }
                Painting painting = new Painting(width, height, resolution, name, author, UUID.randomUUID(), Painting.Type.DATAPACK, flags, hash);
                map.put(painting.location(), Map.entry(painting, (Resource)entry.getValue()));
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load painting {} from {} ({})", new Object[]{imageIdentifier, entry.getKey(), exception});
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, Map.Entry<Painting, Resource>> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ServerPaintingManager.setDatapackPaintings(prepared);
    }
}

