/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.Optional;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.c2s.ImageUploadPayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingRegisterErrorPayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PaintingRegisterPayload(int width, int height, int resolution, String name, EnumSet<Painting.Flag> flags) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<PaintingRegisterPayload> TYPE = new CustomPacketPayload.Type(Main.locate("painting_register"));
    public static final StreamCodec<FriendlyByteBuf, PaintingRegisterPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PaintingRegisterPayload::width, (StreamCodec)ByteBufCodecs.INT, PaintingRegisterPayload::height, (StreamCodec)ByteBufCodecs.INT, PaintingRegisterPayload::resolution, (StreamCodec)ByteBufCodecs.STRING_UTF8, PaintingRegisterPayload::name, Painting.Flag.STREAM_CODEC, PaintingRegisterPayload::flags, PaintingRegisterPayload::new);

    private static void paintingRegisterError(Player player, String error, ResourceLocation i) {
        NetworkHandler.sendToClient((ServerPlayer)player, new PaintingRegisterErrorPayload(Optional.ofNullable(i), error));
    }

    public static ResourceLocation handle(Player player, BufferedImage image, Painting painting) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            String hash = String.format("%032x", new BigInteger(1, md5.digest(ImageManipulations.encode(image))));
            painting = painting.withHash(hash);
            ResourceLocation identifier = painting.location();
            MinecraftServer server = player.getServer();
            if (server != null) {
                ServerPaintingManager.registerPainting(server, identifier, painting, image);
                NetworkHandler.sendToAllClients(server, new PaintingSyncPayload(identifier, painting));
            }
            PaintingRegisterPayload.paintingRegisterError(player, "", identifier);
            return identifier;
        }
        catch (NoSuchAlgorithmException e) {
            Main.LOGGER.error("failed to hash painting {}", (Object)painting.location(), (Object)e);
            PaintingRegisterPayload.paintingRegisterError(player, "hash_failed", null);
        }
        catch (IOException e) {
            Main.LOGGER.error("failed to encode painting {}", (Object)painting.location(), (Object)e);
            PaintingRegisterPayload.paintingRegisterError(player, "hash_failed", null);
        }
        return null;
    }

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        int width = this.width();
        int height = this.height();
        int resolution = this.resolution();
        String name = this.name();
        EnumSet<Painting.Flag> flags = this.flags();
        runner.run(() -> {
            BufferedImage image = ImageUploadPayload.uploaded.remove(player.getStringUUID());
            if (!player.hasPermissions(Configs.COMMON.uploadPermissionLevel)) {
                PaintingRegisterPayload.paintingRegisterError(player, "no_permission", null);
                return;
            }
            long count = ServerPaintingManager.getCustomPaintings(player.getServer()).values().stream().filter(p -> p.authorUUID().equals(player.getUUID())).count();
            if (count > (long)Configs.COMMON.maxUserImages) {
                PaintingRegisterPayload.paintingRegisterError(player, "limit_reached", null);
                return;
            }
            Main.LOGGER.debug("{}, {}, {}, {}", (Object)image.getWidth(), (Object)Configs.COMMON.maxUserImageWidth, (Object)image.getHeight(), (Object)Configs.COMMON.maxUserImageHeight);
            if (image.getWidth() > Configs.COMMON.maxUserImageWidth || image.getHeight() > Configs.COMMON.maxUserImageHeight) {
                if (!Configs.COMMON.automaticImageResizing) {
                    PaintingRegisterPayload.paintingRegisterError(player, "too_large", null);
                    return;
                }
                float z = Math.min((float)Configs.COMMON.maxUserImageWidth / (float)image.getWidth(), (float)Configs.COMMON.maxUserImageHeight / (float)image.getHeight());
                BufferedImage newImage = new BufferedImage((int)((float)image.getWidth() * z), (int)((float)image.getHeight() * z), 2);
                ImageManipulations.resize(newImage, image, 1.0f / z, 0, 0);
                image = newImage;
            }
            Painting p2 = new Painting(width, height, resolution, name, player.getGameProfile().getName(), player.getUUID(), Painting.Type.PAINTING, flags, "");
            PaintingRegisterPayload.handle(player, image, p2);
        });
    }

    public CustomPacketPayload.Type<PaintingRegisterPayload> type() {
        return TYPE;
    }
}

