/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public record PaintingDeletePayload(ResourceLocation identifier, boolean adminDelete) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<PaintingDeletePayload> TYPE = new CustomPacketPayload.Type(Main.locate("painting_delete"));
    public static final StreamCodec<FriendlyByteBuf, PaintingDeletePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PaintingDeletePayload::identifier, (StreamCodec)ByteBufCodecs.BOOL, PaintingDeletePayload::adminDelete, PaintingDeletePayload::new);

    private static void deletePainting(MinecraftServer server, Player player, ResourceLocation painting) {
        ServerPaintingManager.deregisterPainting(server, painting);
        Main.LOGGER.info("Player {} deleted painting {}", (Object)player, (Object)painting);
    }

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        ResourceLocation identifier = this.identifier();
        boolean adminDelete = this.adminDelete();
        runner.run(() -> {
            PaintingSyncPayload payload;
            Painting painting = ServerPaintingManager.getCustomPaintings(player.getServer()).get(identifier);
            UUID authorUUID = painting.authorUUID();
            if (!authorUUID.equals(player.getUUID()) && !player.hasPermissions(4)) {
                Main.LOGGER.warn("Player {} tried to delete painting {}, which they do not own", (Object)player, (Object)identifier);
                return;
            }
            MinecraftServer server = player.getServer();
            if (server == null) {
                return;
            }
            if (adminDelete) {
                Map<ResourceLocation, Optional<Painting>> deletedPaintings = ServerPaintingManager.getCustomPaintings(server).entrySet().stream().filter(p -> ((Painting)p.getValue()).authorUUID().equals(authorUUID) && !((Painting)p.getValue()).is(Painting.Type.DATAPACK)).collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.empty()));
                deletedPaintings.forEach((id, o) -> PaintingDeletePayload.deletePainting(server, player, id));
                payload = new PaintingSyncPayload(deletedPaintings, false);
            } else {
                PaintingDeletePayload.deletePainting(server, player, identifier);
                payload = new PaintingSyncPayload(identifier, null);
            }
            NetworkHandler.sendToAllClients(server, payload);
        });
    }

    public CustomPacketPayload.Type<PaintingDeletePayload> type() {
        return TYPE;
    }
}

