/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.redstoneRequester;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import java.util.Optional;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericLogisticsManager;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_abstractions.generic.support.GenericRedstoneRequester;

@Mixin(value={RedstoneRequesterBlockEntity.class})
public abstract class RedstoneRequesterBlockEntityMixin
extends StockCheckingBlockEntity
implements GenericRedstoneRequester {
    @Unique
    public GenericOrder createFactoryLogistics$encodedRequest = GenericOrder.empty();
    @Shadow
    public boolean allowPartialRequests;
    @Shadow
    public boolean lastRequestSucceeded;
    @Shadow
    public String encodedTargetAdress;

    public RedstoneRequesterBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Overwrite
    public void triggerRequest() {
        if (this.createFactoryLogistics$encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        GenericInventorySummary summaryOfOrder = GenericInventorySummary.empty();
        for (Object stack : this.createFactoryLogistics$encodedRequest.stacks()) {
            summaryOfOrder.add((GenericStack)stack);
        }
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)this.getAccurateSummary());
        for (GenericStack stack : summaryOfOrder.get()) {
            Level level;
            if (summary.getCountOf(stack.key()) >= stack.amount()) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests || !((level = this.level) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, 32.0, (CustomPacketPayload)new RedstoneRequesterEffectPacket(this.worldPosition, false));
            return;
        }
        GenericLogisticsManager.broadcastPackageRequest((UUID)this.behaviour.freqId, (LogisticallyLinkedBehaviour.RequestType)LogisticallyLinkedBehaviour.RequestType.REDSTONE, (GenericOrder)this.createFactoryLogistics$encodedRequest, null, (String)this.encodedTargetAdress);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, 32.0, (CustomPacketPayload)new RedstoneRequesterEffectPacket(this.worldPosition, anySucceeded));
        }
        this.lastRequestSucceeded = true;
    }

    @Redirect(method={"read(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/codecs/CatnipCodecUtils;decode(Lcom/mojang/serialization/Codec;Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;"))
    private Optional<PackageOrderWithCrafts> readRequest(Codec<PackageOrderWithCrafts> codec, HolderLookup.Provider registries, Tag tag) {
        this.createFactoryLogistics$encodedRequest = GenericOrder.read((HolderLookup.Provider)registries, (CompoundTag)((CompoundTag)tag));
        return Optional.empty();
    }

    @Redirect(method={"write(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/codecs/CatnipCodecUtils;encode(Lcom/mojang/serialization/Codec;Lnet/minecraft/core/HolderLookup$Provider;Ljava/lang/Object;)Ljava/util/Optional;"))
    private Optional<Tag> writeRequest(Codec<PackageOrderWithCrafts> codec, HolderLookup.Provider registries, Object t) {
        return Optional.of(this.createFactoryLogistics$encodedRequest.write(registries));
    }

    @Redirect(method={"writeSafe(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/codecs/CatnipCodecUtils;encode(Lcom/mojang/serialization/Codec;Lnet/minecraft/core/HolderLookup$Provider;Ljava/lang/Object;)Ljava/util/Optional;"))
    private Optional<Tag> writeSafeRequest(Codec<PackageOrderWithCrafts> codec, HolderLookup.Provider registries, Object t) {
        return Optional.of(this.createFactoryLogistics$encodedRequest.write(registries));
    }

    public GenericOrder getOrder() {
        return this.createFactoryLogistics$encodedRequest;
    }

    public void setOrder(GenericOrder order) {
        this.createFactoryLogistics$encodedRequest = order;
    }
}

