/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_logistics.CreateFactoryLogistics;
import ru.zznty.create_factory_logistics.FactoryBlockEntities;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.FactoryRecipes;

public class NetworkLinkQualificationRecipe
extends CustomRecipe {
    private final ResourceLocation key;

    public NetworkLinkQualificationRecipe(ResourceLocation key, CraftingBookCategory p_249010_) {
        super(p_249010_);
        this.key = key;
    }

    public boolean matches(CraftingInput p_44002_, Level p_44003_) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(p_44002_.items());
        list.removeIf(ItemStack::isEmpty);
        boolean isEmpty = this.key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"create_factory_abstractions", (String)"empty"));
        if (list.size() != (isEmpty ? 1 : 2)) {
            return false;
        }
        return (isEmpty || list.stream().anyMatch(Ingredient.of(NetworkLinkQualificationRecipe.tag(this.key)))) && list.stream().anyMatch(Ingredient.of((ItemLike[])new ItemLike[]{FactoryBlocks.NETWORK_LINK}));
    }

    @Nullable
    private ResourceLocation test(ItemStack item) {
        return Ingredient.of(NetworkLinkQualificationRecipe.tag(this.key)).test(item) ? this.key : null;
    }

    public static TagKey<Item> tag(ResourceLocation location) {
        if (!GenericContentExtender.REGISTRY.containsKey(location)) {
            throw new IllegalArgumentException("Location" + String.valueOf(location) + " does not belong to ingredient types registry");
        }
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)CreateFactoryLogistics.resource("network_link_qualifier/" + location.getNamespace() + "/" + location.getPath()));
    }

    public ItemStack assemble(CraftingInput p_44001_, HolderLookup.Provider p_267165_) {
        ItemStack link = null;
        ResourceLocation qualifier = null;
        boolean air = true;
        for (int i = 0; i < p_44001_.size(); ++i) {
            if (p_44001_.getItem(i).getItem() == FactoryBlocks.NETWORK_LINK.asItem()) {
                if (link != null) {
                    return ItemStack.EMPTY;
                }
                link = p_44001_.getItem(i);
                continue;
            }
            if (p_44001_.getItem(i).isEmpty()) continue;
            air = false;
            if (qualifier != null) {
                return ItemStack.EMPTY;
            }
            qualifier = this.test(p_44001_.getItem(i));
        }
        if (air) {
            qualifier = GenericContentExtender.DEFAULT_KEY;
        }
        if (link == null || qualifier == null) {
            return ItemStack.EMPTY;
        }
        link = NetworkLinkQualificationRecipe.qualifyTo(link, qualifier);
        if (air) {
            CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)link, t -> t.remove("Freq"));
        }
        return link;
    }

    @NotNull
    public static ItemStack qualifyTo(ItemStack link, ResourceLocation qualifier) {
        link = link.copyWithCount(1);
        CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)link, t -> {
            BlockEntity.addEntityType((CompoundTag)t, (BlockEntityType)((BlockEntityType)FactoryBlockEntities.NETWORK_LINK.get()));
            t.putString("ingredient_type", qualifier.toString());
        });
        return link;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return p_43999_ * p_44000_ >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FactoryRecipes.NETWORK_LINK_QUALIFICATION.get();
    }

    public ResourceLocation key() {
        return this.key;
    }

    public static class Serializer
    implements RecipeSerializer<NetworkLinkQualificationRecipe> {
        private static final StreamCodec<RegistryFriendlyByteBuf, NetworkLinkQualificationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        public static final MapCodec<NetworkLinkQualificationRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)ResourceLocation.CODEC.fieldOf("key").forGetter(NetworkLinkQualificationRecipe::key), (App)CraftingBookCategory.CODEC.fieldOf("category").forGetter(CustomRecipe::category)).apply((Applicative)p_340778_, NetworkLinkQualificationRecipe::new));

        @Nullable
        public static NetworkLinkQualificationRecipe fromNetwork(RegistryFriendlyByteBuf p_44106_) {
            return new NetworkLinkQualificationRecipe(p_44106_.readResourceLocation(), (CraftingBookCategory)p_44106_.readEnum(CraftingBookCategory.class));
        }

        public static void toNetwork(RegistryFriendlyByteBuf p_44101_, NetworkLinkQualificationRecipe p_44102_) {
            p_44101_.writeResourceLocation(p_44102_.key);
            p_44101_.writeEnum((Enum)p_44102_.category());
        }

        public MapCodec<NetworkLinkQualificationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NetworkLinkQualificationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

