/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jar;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.FactoryEntities;
import ru.zznty.create_factory_logistics.logistics.jar.JarItemRenderer;
import ru.zznty.create_factory_logistics.logistics.jar.JarPackageEntity;
import ru.zznty.create_factory_logistics.logistics.jar.JarStyles;
import ru.zznty.create_factory_logistics.logistics.jar.unpack.JarUnpackingHandler;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBehaviour;

public class JarPackageItem
extends PackageItem {
    public JarPackageItem(Item.Properties properties, PackageStyles.PackageStyle style) {
        super(properties, style);
        PackageStyles.ALL_BOXES.remove((Object)this);
        (style.rare() ? PackageStyles.RARE_BOXES : PackageStyles.STANDARD_BOXES).remove((Object)this);
        JarStyles.ALL_JARS.add(this);
    }

    public String getDescriptionId() {
        return "item.create_factory_logistics" + (this.style.rare() ? ".rare_jar" : ".jar");
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return JarPackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        boolean success;
        ItemStack box = playerIn.getItemInHand(handIn);
        BlockHitResult hitResult = JarPackageItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)box);
        }
        BlockPos relative = hitResult.getBlockPos().relative(hitResult.getDirection());
        IFluidHandlerItem fluidItem = (IFluidHandlerItem)box.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidItem == null) {
            return InteractionResultHolder.pass((Object)box);
        }
        FluidStack fluid = fluidItem.drain(Config.jarCapacity, IFluidHandler.FluidAction.SIMULATE);
        if (!(fluid.getAmount() == Config.jarCapacity && fluid.getFluid() instanceof FlowingFluid && worldIn.mayInteract(playerIn, relative) && playerIn.mayUseItemAt(relative, hitResult.getDirection(), box) && worldIn instanceof ServerLevel)) {
            return InteractionResultHolder.fail((Object)box);
        }
        ServerLevel serverLevel = (ServerLevel)worldIn;
        JarUnpackingHandler handler = (JarUnpackingHandler)JarUnpackingHandler.REGISTRY.get((Object)fluid.getFluid());
        if (handler != null) {
            success = handler.unpack(serverLevel, relative, fluid, playerIn);
        } else {
            BlockState blockState = worldIn.getBlockState(hitResult.getBlockPos());
            BlockPos placePos = this.canBlockContainFluid(worldIn, hitResult.getBlockPos(), blockState, fluid) ? hitResult.getBlockPos() : relative;
            success = this.emptyContents(playerIn, worldIn, handIn, placePos, box);
        }
        if (success) {
            playerIn.setItemInHand(handIn, ItemStack.EMPTY);
            return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)worldIn.isClientSide());
        }
        return InteractionResultHolder.fail((Object)box);
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockState, FluidStack fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = blockState.getBlock();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(null, (BlockGetter)worldIn, posIn, blockState, fluid.getFluid());
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return this.open(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
        }
        Vec3 point = context.getClickLocation();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.getClickedFace() == Direction.DOWN) {
            point = point.subtract(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.getClickedFace().getAxis().isHorizontal()) {
            point = point.add(Vec3.atLowerCornerOf((Vec3i)context.getClickedFace().getNormal()).scale((double)r));
        }
        AABB scanBB = new AABB(point, point).inflate((double)r, 0.0, (double)r).expandTowards(0.0, (double)h, 0.0);
        Level world = context.getLevel();
        if (!world.getEntities((EntityTypeTest)FactoryEntities.JAR.get(), scanBB, e -> true).isEmpty()) {
            return InteractionResult.PASS;
        }
        JarPackageEntity jarEntity = new JarPackageEntity(world, point.x, point.y, point.z);
        ItemStack itemInHand = context.getItemInHand();
        jarEntity.setBox(itemInHand.copy());
        world.addFreshEntity((Entity)jarEntity);
        itemInHand.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.getUseDuration(stack, entity) - ticks;
        if (i < 0) {
            return;
        }
        float f = JarPackageItem.getPackageVelocity((int)i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.isClientSide) {
            return;
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.copy();
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        Vec3 vec = new Vec3(entity.getX(), entity.getY() + entity.getBoundingBox().getYsize() / 2.0, entity.getZ());
        Vec3 motion = entity.getLookAngle().scale((double)(f * 2.0f));
        vec = vec.add(motion);
        JarPackageEntity jarEntity = new JarPackageEntity(world, vec.x, vec.y, vec.z);
        jarEntity.setBox(copy);
        jarEntity.setDeltaMovement(motion);
        jarEntity.tossedBy = new WeakReference<Player>(player);
        world.addFreshEntity((Entity)jarEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new JarItemRenderer()));
        super.initializeClient(consumer);
    }

    public static ItemStack slurp(Level world, BlockPos pos, IFluidHandler tank, FluidStack extractedFluid, int amount) {
        ItemStack jar;
        FluidActionResult result;
        if (amount < 1) {
            amount = Config.jarCapacity;
        }
        if (!(result = FluidUtil.tryFillContainer((ItemStack)(jar = new ItemStack((ItemLike)JarStyles.getRandomJar())), (IFluidHandler)tank, (int)amount, null, (boolean)true)).isSuccess()) {
            return ItemStack.EMPTY;
        }
        world.playSound(null, pos, FluidHelper.getFillSound((FluidStack)extractedFluid), SoundSource.BLOCKS, 0.5f, 1.0f);
        return result.getResult();
    }

    public static ItemStack getDefaultJar() {
        return JarStyles.ALL_JARS.get(0).getDefaultInstance();
    }

    public boolean emptyContents(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, ItemStack container) {
        FluidStack resource = FluidUtil.getFluidContained((ItemStack)container).orElse(FluidStack.EMPTY);
        if (resource.getAmount() < 1000) {
            return false;
        }
        return FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)pos, (ItemStack)container, (FluidStack)resource).isSuccess();
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext tooltipContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, tooltipContext, pTooltipComponents, pIsAdvanced);
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)pStack).orElse(FluidStack.EMPTY);
        if (contained.isEmpty()) {
            return;
        }
        pTooltipComponents.add((Component)contained.getHoverName().copy().append(" ").append((Component)FactoryFluidPanelBehaviour.formatLevel(contained.getAmount()).component()).withStyle(ChatFormatting.GRAY));
    }
}

