/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import com.mojang.serialization.Codec;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeySerializer;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;

public class FluidKeySerializer
implements GenericKeySerializer<FluidKey> {
    public FluidKey read(HolderLookup.Provider registries, CompoundTag tag) {
        String key = tag.getString("id");
        return key.isEmpty() ? new FluidKey((Holder<Fluid>)Fluids.EMPTY.builtInRegistryHolder(), null) : new FluidKey((Holder<Fluid>)((Holder)BuiltInRegistries.FLUID.getHolder(ResourceLocation.parse((String)key)).get()), tag.contains("Tag") ? PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)CatnipCodecUtils.decode((Codec)DataComponentPatch.CODEC, (Tag)tag.getCompound("Tag")).orElse(DataComponentPatch.EMPTY)) : new PatchedDataComponentMap(DataComponentMap.EMPTY));
    }

    public void write(FluidKey key, HolderLookup.Provider registries, CompoundTag tag) {
        @Nullable ResourceKey resourceKey = key.fluid().getKey();
        tag.putString("id", resourceKey == null ? "minecraft:air" : resourceKey.location().toString());
        CatnipCodecUtils.encode((Codec)DataComponentPatch.CODEC, (Object)key.nbt().asPatch()).ifPresent(t -> tag.put("Tag", t));
    }

    public FluidKey read(RegistryFriendlyByteBuf buf) {
        Holder.Reference fluid = BuiltInRegistries.FLUID.getHolderOrThrow(buf.readResourceKey(BuiltInRegistries.FLUID.key()));
        DataComponentPatch nbt = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
        return new FluidKey((Holder<Fluid>)fluid, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)nbt));
    }

    public void write(FluidKey key, RegistryFriendlyByteBuf buf) {
        buf.writeResourceKey(key.fluid().getKey());
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)key.nbt().asPatch());
    }
}

