/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.composite;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import ru.zznty.create_factory_logistics.FactoryItems;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageEntity;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageRenderer;

public class CompositePackageItem
extends PackageItem {
    public static final String CHILDREN_TAG = "Children";
    public static final String ITEMS_TAG = "CompositeItems";

    public CompositePackageItem(Item.Properties properties) {
        super(properties, (PackageStyles.PackageStyle)PackageStyles.STYLES.get(1));
        PackageStyles.ALL_BOXES.remove((Object)this);
        PackageStyles.STANDARD_BOXES.remove((Object)this);
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return CompositePackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag);
        int visibleNames = 0;
        int skippedNames = 0;
        ItemStackHandler contents = CompositePackageItem.getContents(tooltipContext.registries(), stack);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack itemstack = contents.getStackInSlot(i);
            if (itemstack.isEmpty() || itemstack.getItem() instanceof SpawnEggItem) continue;
            if (visibleNames > 2) {
                ++skippedNames;
                continue;
            }
            ++visibleNames;
            tooltipComponents.add((Component)itemstack.getHoverName().copy().append(" x").append(String.valueOf(itemstack.getCount())).withStyle(ChatFormatting.GRAY));
        }
        if (skippedNames > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{skippedNames}).withStyle(ChatFormatting.ITALIC));
        }
        for (ItemStack child : CompositePackageItem.getChildren(tooltipContext.registries(), stack)) {
            child.getItem().appendHoverText(child, tooltipContext, tooltipComponents, tooltipFlag);
        }
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack box = playerIn.getItemInHand(handIn);
        playerIn.setItemInHand(handIn, PackageItem.containing((ItemStackHandler)CompositePackageItem.getContents((HolderLookup.Provider)worldIn.registryAccess(), box)));
        InteractionResultHolder resultHolder = super.open(worldIn, playerIn, handIn);
        if (resultHolder.getResult() == InteractionResult.SUCCESS && !worldIn.isClientSide()) {
            for (ItemStack child : CompositePackageItem.getChildren((HolderLookup.Provider)worldIn.registryAccess(), box)) {
                playerIn.getInventory().placeItemBackInInventory(child);
            }
        }
        return new InteractionResultHolder(resultHolder.getResult(), (Object)box);
    }

    public static List<ItemStack> getChildren(HolderLookup.Provider lookupProvider, ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA) || !((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains(CHILDREN_TAG)) {
            return List.of();
        }
        ListTag listTag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getList(CHILDREN_TAG, 10);
        return NBTHelper.readCompoundList((ListTag)listTag, t -> ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)t));
    }

    public static ItemStackHandler getContents(HolderLookup.Provider lookupProvider, ItemStack box) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        CustomData customData = (CustomData)box.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.contains(ITEMS_TAG)) {
            newInv.deserializeNBT(lookupProvider, customData.getUnsafe().getCompound(ITEMS_TAG));
        }
        return newInv;
    }

    public static ItemStack of(HolderLookup.Provider lookupProvider, ItemStack box, List<ItemStack> originalChildren) {
        if (originalChildren.isEmpty()) {
            return PackageItem.containing((ItemStackHandler)PackageItem.getContents((ItemStack)box));
        }
        ItemStack compositeBox = new ItemStack((ItemLike)FactoryItems.COMPOSITE_PACKAGE.get());
        PatchedDataComponentMap components = new PatchedDataComponentMap(box.getComponents());
        components.remove(AllDataComponents.PACKAGE_CONTENTS);
        compositeBox.applyComponents((DataComponentMap)components);
        ArrayList<ItemStack> children = new ArrayList<ItemStack>(originalChildren);
        ItemStackHandler contents = PackageItem.getContents((ItemStack)box);
        CompoundTag tag = ((CustomData)compositeBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ListTag listTag = tag.getList(CHILDREN_TAG, 10);
        if (!listTag.isEmpty()) {
            children.addAll(CompositePackageItem.getChildren(lookupProvider, compositeBox));
            listTag.clear();
        }
        for (int i = 0; i < children.size(); ++i) {
            ItemStack child = (ItemStack)children.get(i);
            if (!(child.getItem() instanceof CompositePackageItem)) continue;
            children.addAll(CompositePackageItem.getChildren(lookupProvider, child));
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)child, childTag -> childTag.remove(CHILDREN_TAG));
            ItemStackHandler childContents = PackageItem.getContents((ItemStack)child);
            boolean emptied = true;
            for (int slot = 0; slot < childContents.getSlots(); ++slot) {
                ItemStack reminder = ItemHandlerHelper.insertItemStacked((IItemHandler)contents, (ItemStack)childContents.getStackInSlot(slot), (boolean)false);
                childContents.setStackInSlot(slot, reminder);
                if (reminder.isEmpty()) continue;
                emptied = false;
            }
            if (!emptied) {
                children.add(PackageItem.containing((ItemStackHandler)childContents));
            }
            children.remove(i);
            --i;
        }
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)compositeBox, t -> {
            t.put(CHILDREN_TAG, (Tag)NBTHelper.writeCompoundList((Iterable)children, s -> (CompoundTag)s.saveOptional(lookupProvider)));
            t.put(ITEMS_TAG, (Tag)contents.serializeNBT(lookupProvider));
        });
        return compositeBox;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new CompositePackageRenderer()));
        super.initializeClient(consumer);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return this.open(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
        }
        Vec3 point = context.getClickLocation();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.getClickedFace() == Direction.DOWN) {
            point = point.subtract(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.getClickedFace().getAxis().isHorizontal()) {
            point = point.add(Vec3.atLowerCornerOf((Vec3i)context.getClickedFace().getNormal()).scale((double)r));
        }
        AABB scanBB = new AABB(point, point).inflate((double)r, 0.0, (double)r).expandTowards(0.0, (double)h, 0.0);
        Level world = context.getLevel();
        if (!world.getEntities((EntityTypeTest)AllEntityTypes.PACKAGE.get(), scanBB, e -> true).isEmpty()) {
            return super.useOn(context);
        }
        CompositePackageEntity packageEntity = new CompositePackageEntity(world, point.x, point.y, point.z);
        ItemStack itemInHand = context.getItemInHand();
        packageEntity.setBox(itemInHand.copy());
        world.addFreshEntity((Entity)packageEntity);
        itemInHand.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.getUseDuration(stack, entity) - ticks;
        if (i < 0) {
            return;
        }
        float f = CompositePackageItem.getPackageVelocity((int)i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.isClientSide) {
            return;
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.copy();
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        Vec3 vec = new Vec3(entity.getX(), entity.getY() + entity.getBoundingBox().getYsize() / 2.0, entity.getZ());
        Vec3 motion = entity.getLookAngle().scale((double)(f * 2.0f));
        vec = vec.add(motion);
        CompositePackageEntity packageEntity = new CompositePackageEntity(world, vec.x, vec.y, vec.z);
        packageEntity.setBox(copy);
        packageEntity.setDeltaMovement(motion);
        packageEntity.tossedBy = new WeakReference<Player>(player);
        world.addFreshEntity((Entity)packageEntity);
    }
}

