/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.HangingSignTileExtension;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class HangingSignRendererExtension {
    public static LayerDefinition createMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("extension_6", CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, -8.0f, -2.0f, 2.0f, 6.0f, 4.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.addOrReplaceChild("extension_5", CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, -8.0f, -2.0f, 2.0f, 5.0f, 4.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.addOrReplaceChild("extension_4", CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, -8.0f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-1.5708f));
        partDefinition.addOrReplaceChild("extension_3", CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, -8.0f, -2.0f, 2.0f, 3.0f, 4.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)-1.5708f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public static LayerDefinition createChainMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        root.addOrReplaceChild("chainL1", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.addOrReplaceChild("chainL2", CubeListBuilder.create().texOffs(6, 7).addBox(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.addOrReplaceChild("chainR1", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.addOrReplaceChild("chainR2", CubeListBuilder.create().texOffs(6, 7).addBox(-1.5f, 1.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static void render(SignBlockEntity tile, HangingSignTileExtension extension, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, BlockState state, HangingSignRenderer.HangingSignModel model, List<ModelPart> barModel, ModelPart chains, Material material, Material extensionMaterial, SignRenderer renderer, float colorMult, boolean translucent) {
        VertexConsumer vc2;
        ModBlockProperties.PostType left;
        ModBlockProperties.PostType right;
        block13: {
            block12: {
                poseStack.pushPose();
                boolean wallSign = !(state.getBlock() instanceof CeilingHangingSignBlock);
                boolean attached = !wallSign && state.hasProperty((Property)BlockStateProperties.ATTACHED) && (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false;
                poseStack.translate(0.5, 0.875, 0.5);
                Quaternionf yaw = attached ? Axis.YP.rotationDegrees(-RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)CeilingHangingSignBlock.ROTATION)))) : Axis.YP.rotationDegrees(HangingSignRendererExtension.getSignAngle(state, wallSign));
                poseStack.mulPose(yaw);
                model.evaluateVisibleParts(state);
                VertexConsumer vertexConsumer = material.buffer(bufferSource, translucent ? RenderType::entityTranslucent : arg_0 -> ((HangingSignRenderer.HangingSignModel)model).renderType(arg_0));
                poseStack.scale(1.0f, -1.0f, -1.0f);
                boolean visible = model.plank.visible;
                boolean visibleC = model.normalChains.visible;
                model.plank.visible = false;
                if (wallSign) {
                    model.normalChains.visible = false;
                }
                poseStack.pushPose();
                Quaternionf pitch = new Quaternionf();
                if (extension.canSwing()) {
                    float rot = extension.getClientAnimation().getAngle(partialTicks);
                    pitch = !wallSign && attached ? Axis.YP.rotationDegrees(rot) : Axis.XP.rotationDegrees(rot);
                    if (!wallSign) {
                        poseStack.translate(0.0, -0.125, 0.0);
                    }
                    poseStack.mulPose(pitch);
                    if (!wallSign) {
                        poseStack.translate(0.0, 0.125, 0.0);
                    }
                }
                Vector3f norm = Direction.SOUTH.step().rotate((Quaternionfc)pitch).rotate((Quaternionfc)yaw);
                poseStack.pushPose();
                poseStack.translate(0.0, 0.25, 0.0);
                model.root.render(poseStack, vertexConsumer, light, overlay);
                if (wallSign) {
                    chains.render(poseStack, vertexConsumer, light, overlay);
                    model.normalChains.visible = visibleC;
                }
                model.plank.visible = visible;
                poseStack.popPose();
                poseStack.scale(1.0f, -1.0f, -1.0f);
                Minecraft mc = Minecraft.getInstance();
                Camera camera = mc.gameRenderer.getMainCamera();
                Font font = mc.font;
                boolean filtered = mc.isTextFilteringEnabled();
                LOD lod = LOD.at((BlockEntity)tile);
                poseStack.pushPose();
                HangingSignRendererExtension.renderFront(tile, extension, poseStack, bufferSource, light, overlay, renderer, colorMult, norm, font, filtered, lod);
                poseStack.popPose();
                poseStack.pushPose();
                HangingSignRendererExtension.renderBack(tile, extension, poseStack, bufferSource, light, overlay, renderer, colorMult, norm, font, filtered, lod);
                poseStack.popPose();
                poseStack.popPose();
                poseStack.translate(0.0, 0.25, 0.0);
                if (visible) {
                    model.plank.render(poseStack, vertexConsumer, light, overlay);
                }
                right = extension.getRightAttachment();
                left = extension.getLeftAttachment();
                if (!ClientConfigs.SIGN_ATTACHMENT.get().booleanValue()) {
                    right = null;
                    left = null;
                }
                vc2 = null;
                if (right != null) break block12;
                if (left == null) break block13;
            }
            vc2 = extensionMaterial.buffer(bufferSource, arg_0 -> ((HangingSignRenderer.HangingSignModel)model).renderType(arg_0));
        }
        if (left != null) {
            poseStack.pushPose();
            poseStack.translate(1.0f, 0.0f, 0.0f);
            barModel.get(left.ordinal()).render(poseStack, vc2, light, overlay);
            poseStack.popPose();
        }
        if (right != null) {
            poseStack.pushPose();
            poseStack.mulPose(RotHlpr.Y180);
            poseStack.translate(1.0f, 0.0f, 0.0f);
            barModel.get(right.ordinal()).render(poseStack, vc2, light, overlay);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static void renderFront(SignBlockEntity tile, HangingSignTileExtension extension, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, SignRenderer renderer, float colorMult, Vector3f norm, Font font, boolean filtered, LOD lod) {
        Item item;
        ItemStack item2 = extension.getFrontItem();
        if (item2.isEmpty()) {
            renderer.translateSignText(poseStack, true, renderer.getTextOffset());
            HangingSignRendererExtension.renderSignText(tile.getFrontText(), font, poseStack, buffer, light, norm, lod, filtered, tile.getTextLineHeight(), tile.getMaxTextLineWidth(), colorMult);
        } else if (CompatHandler.SUPPLEMENTARIES && (item = item2.getItem()) instanceof BannerPatternItem) {
            BannerPatternItem banner = (BannerPatternItem)item;
            HangingSignRendererExtension.renderBannerPattern(tile.getLevel(), tile.getFrontText(), poseStack, buffer, light, banner);
        } else {
            poseStack.mulPose(RotHlpr.Y180);
            HangingSignRendererExtension.renderItem(item2, poseStack, buffer, light, overlay, tile.getLevel());
        }
    }

    private static void renderBack(SignBlockEntity tile, HangingSignTileExtension extension, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, SignRenderer renderer, float colorMult, Vector3f norm, Font font, boolean filtered, LOD lod) {
        Item item;
        ItemStack item2 = extension.getBackItem();
        if (item2.isEmpty()) {
            renderer.translateSignText(poseStack, false, renderer.getTextOffset());
            HangingSignRendererExtension.renderSignText(tile.getBackText(), font, poseStack, buffer, light, norm.mul(-1.0f), lod, filtered, tile.getTextLineHeight(), tile.getMaxTextLineWidth(), colorMult);
        } else if (CompatHandler.SUPPLEMENTARIES && (item = item2.getItem()) instanceof BannerPatternItem) {
            BannerPatternItem banner = (BannerPatternItem)item;
            poseStack.mulPose(RotHlpr.Y180);
            HangingSignRendererExtension.renderBannerPattern(tile.getLevel(), tile.getBackText(), poseStack, buffer, light, banner);
        } else {
            HangingSignRendererExtension.renderItem(item2, poseStack, buffer, light, overlay, tile.getLevel());
        }
    }

    private static float getSignAngle(BlockState state, boolean attachedToWall) {
        return attachedToWall ? -((Direction)state.getValue((Property)WallSignBlock.FACING)).toYRot() : -((float)((Integer)state.getValue((Property)CeilingHangingSignBlock.ROTATION) * 360) / 16.0f);
    }

    public static void renderSignText(SignText signText, Font font, PoseStack poseStack, MultiBufferSource buffer, int light, Vector3f normal, LOD lod, boolean filtered, int lineHeight, int lineWidth, float colorMult) {
        TextUtil.RenderProperties properties = TextUtil.renderProperties((DyeColor)signText.getColor(), (boolean)signText.hasGlowingText(), (float)colorMult, (int)light, (Style)Style.EMPTY, (Vector3f)normal, () -> ((LOD)lod).isVeryNear());
        FormattedCharSequence[] formattedCharSequences = signText.getRenderMessages(filtered, component -> {
            List list = font.split((FormattedText)component, lineWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        for (int i = 0; i < formattedCharSequences.length; ++i) {
            TextUtil.renderLine((FormattedCharSequence)formattedCharSequences[i], (Font)font, (float)(lineHeight * i), (PoseStack)poseStack, (MultiBufferSource)buffer, (TextUtil.RenderProperties)properties);
        }
    }

    private static void renderBannerPattern(Level level, SignText sign, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, BannerPatternItem banner) {
        Material renderMaterial = SuppCompat.getFlagMaterial(level, banner);
        if (renderMaterial != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, -0.5625, 0.0635);
            float scale = ClientConfigs.getItemPixelScale() / 14.0f;
            poseStack.scale(scale, -scale, -1.0f);
            VertexConsumer consumer = renderMaterial.buffer(bufferSource, RenderType::entityNoOutline);
            int color = sign.getColor().getTextureDiffuseColor();
            int b = FastColor.ARGB32.blue((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int r = FastColor.ARGB32.red((int)color);
            int light = packedLight;
            if (sign.hasGlowingText()) {
                light = 0xF000F0;
            }
            int lu = light & 0xFFFF;
            int lv = light >> 16 & 0xFFFF;
            VertexUtil.addQuad((VertexConsumer)consumer, (PoseStack)poseStack, (float)-0.4375f, (float)-0.4375f, (float)0.4375f, (float)0.4375f, (float)0.59375f, (float)0.9375f, (float)0.15625f, (float)0.0625f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
            poseStack.popPose();
        }
    }

    public static void renderItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, Level level) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = itemRenderer.getModel(stack, level, null, 0);
        poseStack.pushPose();
        float z = model.isGui3d() ? 0.109375f : 0.078125f;
        poseStack.translate(0.0f, -0.5625f, -z);
        float scale = ClientConfigs.getItemPixelScale() / 16.0f;
        poseStack.scale(scale, scale, scale);
        itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, light, overlay, model);
        poseStack.popPose();
    }
}

