/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.resources;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TimeCrystal
extends Item {
    public TimeCrystal() {
        super(new Item.Properties());
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (world.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (world.random.nextFloat() < 0.005f) {
                if (this.timeProtection(entity)) {
                    return;
                }
                boolean applySlowness = world.random.nextBoolean();
                if (applySlowness) {
                    if (!livingEntity.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 5, false, false));
                    }
                } else if (!livingEntity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 5, false, false));
                }
            }
        }
    }

    public boolean timeProtection(Entity entity) {
        ToggleableTool toggleableTool;
        Player player;
        ItemStack chestplate;
        Item item;
        if (entity instanceof Player && (item = (chestplate = (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST)).getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(chestplate, Ability.TIMEPROTECTION)) {
            Helpers.damageTool(chestplate, (LivingEntity)player, Ability.TIMEPROTECTION);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        boolean showFirstTooltip;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        boolean bl = showFirstTooltip = currentTime / 10000L % 2L == 0L;
        if (showFirstTooltip) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.timecrystaltooltip").withStyle(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)Component.translatable((String)"justdirethings.timecrystaltooltiptwo").withStyle(ChatFormatting.DARK_AQUA));
        }
    }
}

